/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgTimeDate;
import de.axway.aim.controller.master.cfg.CfgTimeOneDate;
import de.axway.aim.controller.master.cfg.CfgTimeTime;
import de.axway.aim.controller.master.cfg.CfgTimeWeekday;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextCfgTimeWindow
extends CfgTimeWindow {
    private static Log log = LogFactory.getLog((String)"master.cfg.TextCfgTimeWindow");
    private static Map<String, Ident> identifier = new Hashtable<String, Ident>();
    private File file;

    public TextCfgTimeWindow(File file) throws IOException, CfgException {
        this.file = file;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        ILogbook logbook = Logbook.getLogbook();
        File twLock = TextCfg.checkSetLock(logbook, log, Ediboss.timeWindowPath + ".lock");
        logbook.info("reading " + this.file.getAbsolutePath());
        if (!this.file.canRead()) {
            if (twLock.exists()) {
                twLock.delete();
            }
            throw new IOException("Can not read " + this.file.getAbsolutePath());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("open Timewindow configuration file: '" + this.file + "'"));
        }
        int count = 0;
        int lineNo = 0;
        CfgTimeWindowEntry entry = null;
        CfgTimeDate date = null;
        CfgTimeWeekday wd = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));){
            if (log.isDebugEnabled()) {
                log.debug((Object)("Timewindow configuration file: '" + this.file + "' opended."));
            }
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                String tLine = line.trim();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("read line: '" + line + "'"));
                }
                if (tLine.length() > 0 && !tLine.startsWith("#")) {
                    String paramName = TextCfg.getParamName(tLine);
                    if (paramName == null) {
                        logbook.error("no parameter found, line " + lineNo);
                    } else {
                        Ident id = identifier.get(paramName);
                        String param = null;
                        try {
                            param = TextCfg.getParam(tLine);
                        }
                        catch (CfgException e) {
                            logbook.warning(e.getMessage() + " in line " + lineNo + ", ignored");
                        }
                        if (id == null) {
                            logbook.warning("Unknown parameter " + tLine + " in line " + lineNo);
                        } else if (param != null && param.length() > 0) {
                            if (id != Ident.WINDOWNAME && entry == null) {
                                logbook.error("no WINDOWNAME defined, line: " + lineNo);
                            } else {
                                switch (id) {
                                    case WINDOWNAME: {
                                        try {
                                            if (entry != null && log.isDebugEnabled()) {
                                                log.debug((Object)("Timewindow entry read: " + entry));
                                            }
                                            entry = new CfgTimeWindowEntry(param.trim());
                                            this.newEntry(entry);
                                            ++count;
                                        }
                                        catch (CfgException e) {
                                            entry = null;
                                            logbook.error("" + e.getMessage() + ", ignored, line " + lineNo);
                                        }
                                        date = null;
                                        wd = null;
                                        break;
                                    }
                                    case CALENDAR: {
                                        break;
                                    }
                                    case DATE: {
                                        if (entry != null) {
                                            try {
                                                date = new CfgTimeDate(new CfgTimeOneDate(param));
                                                entry.addDate(date);
                                                date.setWeekday(CfgTimeWeekday.getDefault());
                                            }
                                            catch (CfgException e) {
                                                date = null;
                                                logbook.error("" + e.getMessage() + ", ignored, line " + lineNo);
                                            }
                                            wd = null;
                                            break;
                                        }
                                        logbook.error("No WINDOW_NAME defined, ignore " + paramName + " parameter.");
                                        break;
                                    }
                                    case WEEKDAY: {
                                        if (date != null) {
                                            try {
                                                wd = new CfgTimeWeekday(param);
                                                date.setWeekday(wd);
                                            }
                                            catch (CfgException e) {
                                                wd = null;
                                                logbook.error("" + e.getMessage() + ", ignored, line " + lineNo);
                                            }
                                            break;
                                        }
                                        logbook.error("No DATE entry for WINDOWNAME defined, ignore " + paramName + " parameter.");
                                        break;
                                    }
                                    case TIME: {
                                        if (date != null) {
                                            try {
                                                date.addTime(new CfgTimeTime(param));
                                            }
                                            catch (CfgException e) {
                                                logbook.error("" + e.getMessage() + ", ignored, line " + lineNo);
                                            }
                                            break;
                                        }
                                        logbook.error("No DATE entry for WINDOWNAME defined, ignore " + paramName + " parameter.");
                                        break;
                                    }
                                    default: {
                                        logbook.warning("Parameter " + tLine + " in line " + lineNo + " not for TimeWindow.");
                                    }
                                }
                            }
                        }
                    }
                }
                line = br.readLine();
            }
            if (entry != null && log.isDebugEnabled()) {
                log.debug((Object)("Timewindow entry read: " + entry));
            }
        }
        if (twLock.exists()) {
            twLock.delete();
        }
        logbook.info(this.file.getName() + ": " + count + " entries");
    }

    static {
        identifier.put("WINDOWNAME", Ident.WINDOWNAME);
        identifier.put("CALENDAR", Ident.CALENDAR);
        identifier.put("DATE", Ident.DATE);
        identifier.put("WEEKDAY", Ident.WEEKDAY);
        identifier.put("TIME", Ident.TIME);
    }

    private static enum Ident {
        WINDOWNAME,
        CALENDAR,
        DATE,
        WEEKDAY,
        TIME;

    }
}

