/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.lib.util.ActisFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextEdiboss
extends Ediboss {
    private static Map<String, Ident> id = new Hashtable<String, Ident>();

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("WAIT_REMOVE_JOB=");
        out.append(TextCfg.getTime(this.getJobRemoveDelay()));
        out.append("\nWAIT_REMOVE_EVENT=");
        out.append(TextCfg.getTime(this.getEventRemoveDelay()));
        out.append("\nON_ERROR=");
        out.append(this.getOnError());
        out.append("\nON_RETRY_FULL=");
        out.append(this.getOnRetryFull());
        out.append("\nMASTER_EXEC_TIMEOUT=");
        out.append(this.getMasterExecTimeout());
        out.append("\nSLAVEPATH=");
        out.append(this.getSlavePath());
        out.append("\nTWINDOWPATH=");
        out.append(this.getTimeWindowPath());
        out.append("\nRCCPATH=");
        out.append(this.getRccPath());
        out.append("\nFDECLPATH=");
        out.append(this.getFctnPath());
        out.append("\nJSLPATH=");
        out.append(this.getJslPath());
        out.append("\nJOBPATH=");
        out.append(this.getJobPath());
        out.append("\nLOGFILEPATH=");
        out.append(this.getLogfilePath());
        out.append("\nLICENSEPATH=");
        out.append(this.getLicensePath());
        out.append("\nPROTPOOLPATH=");
        out.append(this.getProtpoolPath());
        out.append("\nPROTFILE_DIR=");
        out.append(this.getProtfileDir());
        out.append("\nMASTER_SERVICE=");
        out.append(this.getServerPort());
        out.append("\nIPCLISTENQUEUEENTRIES=");
        out.append(this.getBacklog());
        out.append("\nIPCRWTIMEOUT=");
        out.append(this.getIpcRwTimeout());
        out.append("\nIPCCONNECTTIMEOUT=");
        out.append(this.getIpcConnectTimeout());
        out.append("\nIPCTCPNODELAY=");
        out.append(this.getIpcNoDelay() ? (char)'1' : '0');
        out.append("\nLOAD_FETCH_SIZE=");
        out.append(this.getLoadFetchSize());
        out.append("\nDB_URL=");
        out.append(this.getDbUrl());
        out.append("\nDB_USER_NAME=");
        out.append(this.getDbUser());
        out.append("\nDB_DRIVER=");
        out.append(this.getDbDriver());
        out.append("\nDB_PASSWORD=***");
        out.append("\nACCOUNTING_IN_FILE=");
        out.append(this.getAccountingInFile());
        out.append("\nACCOUNTING_IN_DB=");
        out.append(this.getAccountingInDb());
        out.append("\nACCOUNTING_DB_URL=");
        out.append(this.getAccountingDbUrl());
        out.append("\nACCOUNTING_DB_USER_NAME=");
        out.append(this.getAccountingDbUser());
        out.append("\nACCOUNTING_DB_DRIVER=");
        out.append(this.getAccountingDbDriver());
        out.append("\nACCOUNTING_DB_PASSWORD=***");
        out.append("\nRUNTIME_THREADPOOL=");
        out.append(this.getThreadPool());
        out.append("\nREMOVE_JOB_THREADPOOL=");
        out.append(this.getRemoveThreadPool());
        out.append("\nACCOUNTING_ON=");
        out.append(this.getAccountingOn());
        out.append("\nACCOUNTFILE_DIR=");
        out.append(this.getAccountfileDir());
        out.append("\nRCBACCOUNTING_ON=");
        out.append(this.getRcbAccountingOn());
        out.append("\nRCBACCOUNTFILEPATH=");
        out.append(this.getRcbAccountfilePath());
        out.append("\nREAD_RUNTIME_ON_RCF=");
        out.append(this.readRuntimeOnRcf() ? (char)'1' : '0');
        out.append("\nAUTO_REMOVE_ON=");
        out.append(this.getAutoRemoveOn() ? (char)'y' : 'n');
        out.append("\nARCHIVE_ON=");
        out.append(this.getArchiveOn() ? (char)'y' : 'n');
        out.append("\nARCHIVE_CMD=");
        out.append(this.getArchiveCmd());
        out.append("\nTRKAPIPATH=");
        out.append(this.getTrkApiPath());
        out.append("\nTIME_HOLDJOBRAM=");
        out.append(this.getTimeHoldJobRam());
        out.append("\nSIZE_JOBHASH=");
        out.append(this.getSizeJobHash());
        out.append("\nMAX_JS_DISPATCH=");
        out.append(this.getMaxJsDispatch());
        out.append("\nDEL_DB_JOB=");
        out.append(this.delDbJob() ? (char)'y' : 'n');
        out.append("\nDEL_DB_EVENT=");
        out.append(this.delDbEvent() ? (char)'y' : 'n');
        out.append("\nMAX_LOGPROT_LINES=");
        out.append(this.getMaxLogprotLines());
        out.append("\nKEEP_EMPTY_VARS=");
        out.append(TextEdiboss.isKeepEmptyVars());
        out.append("\nKEEP_UNKNOWN_VARS=");
        out.append(TextEdiboss.isKeepUnknownVars());
        return out.toString();
    }

    public TextEdiboss() throws IOException {
        Log log = LogFactory.getLog((String)"master.cfg.Ediboss");
        String file = "param/ipc.par";
        try {
            this.load(file, log);
        }
        catch (IOException e) {
            log.error((Object)(file + ": " + e.getMessage()));
        }
        this.load("param/ediboss.par", log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String filename, Log log) throws IOException {
        log.info((Object)("reading " + filename));
        if (filename == null || filename.length() <= 0) {
            throw new IOException("no filename");
        }
        String sfile = new ActisFile(filename, 1).toString();
        if (sfile == null || sfile.length() <= 0) {
            throw new IOException("no actis file: " + filename);
        }
        File file = new File(sfile);
        int lineNo = 0;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line = br.readLine();
            while (line != null) {
                String tLine;
                ++lineNo;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ediboss line " + lineNo + ": " + line));
                }
                if ((tLine = line.trim()).length() > 0 && !tLine.startsWith("#")) {
                    String paramName = TextCfg.getParamName(tLine);
                    if (paramName == null) {
                        log.error((Object)("no parameter found, line " + lineNo));
                    } else {
                        Ident ident = id.get(paramName);
                        String param = null;
                        try {
                            param = TextCfg.getParam(tLine);
                        }
                        catch (CfgException e) {
                            log.warn((Object)(e.getMessage() + " in line " + lineNo + ", ignored"));
                        }
                        if (ident != null && param != null) {
                            switch (ident) {
                                case WAIT_REMOVE_JOB: {
                                    try {
                                        this.setJobRemoveDelay(TextCfg.getTime(param));
                                    }
                                    catch (CfgException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case WAIT_REMOVE_EVENT: {
                                    try {
                                        this.setEventRemoveDelay(TextCfg.getTime(param));
                                    }
                                    catch (CfgException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case ON_ERROR: {
                                    try {
                                        this.setOnError(param);
                                    }
                                    catch (ParameterException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case ON_RETRY_FULL: {
                                    try {
                                        this.setOnRetryFull(param);
                                    }
                                    catch (ParameterException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case MASTER_EXEC_TIMEOUT: {
                                    this.setMasterExecTimeout(TextCfg.getInt(param));
                                    break;
                                }
                                case SLAVE_PATH: {
                                    this.setSlavePath(param);
                                    break;
                                }
                                case TIMEWINDOW_PATH: {
                                    this.setTimeWindowPath(param);
                                    break;
                                }
                                case RCC_PATH: {
                                    this.setRccPath(param);
                                    break;
                                }
                                case FCTN_PATH: {
                                    this.setFctnPath(param);
                                    break;
                                }
                                case JSL_PATH: {
                                    this.setJslPath(param);
                                    break;
                                }
                                case JOB_PATH: {
                                    this.setJobPath(param);
                                    break;
                                }
                                case LOGFILE_PATH: {
                                    this.setLogfilePath(param);
                                    break;
                                }
                                case LICENSE_PATH: {
                                    this.setLicensePath(param);
                                    break;
                                }
                                case PROTPOOL_PATH: {
                                    this.setProtpoolPath(param);
                                    break;
                                }
                                case PROTFILE_DIR: {
                                    this.setProtfileDir(param);
                                    break;
                                }
                                case SERVER_PORT: {
                                    this.setServerPort(TextCfg.getInt(param));
                                    break;
                                }
                                case IPC_BACKLOG: {
                                    this.setBacklog(TextCfg.getInt(param));
                                    break;
                                }
                                case IPC_RW_TIMEOUT: {
                                    this.setIpcRwTimeout(TextCfg.getInt(param));
                                    break;
                                }
                                case IPC_CONNECT_TIMEOUT: {
                                    this.setIpcConnectTimeout(TextCfg.getInt(param));
                                    break;
                                }
                                case IPC_NODELAY: {
                                    if (param.equals("0")) {
                                        this.setIpcNoDelay(false);
                                        break;
                                    }
                                    this.setIpcNoDelay(true);
                                    break;
                                }
                                case LOAD_FETCH_SIZE: {
                                    this.setLoadFetchSize(TextCfg.getInt(param));
                                    break;
                                }
                                case DB_DRIVER: {
                                    this.setDbDriver(param);
                                    break;
                                }
                                case DB_URL: {
                                    this.setDbUrl(param);
                                    break;
                                }
                                case DB_USER: {
                                    this.setDbUser(param);
                                    break;
                                }
                                case DB_PASS: {
                                    this.setDbPass(param);
                                    break;
                                }
                                case ACCOUNTING_IN_FILE: {
                                    try {
                                        this.setAccountingInFile(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + this.getAccountingInFile() + " as default."));
                                    }
                                    break;
                                }
                                case ACCOUNTING_IN_DB: {
                                    try {
                                        this.setAccountingInDb(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + this.getAccountingInDb() + " as default."));
                                    }
                                    break;
                                }
                                case ACCOUNTING_DB_DRIVER: {
                                    this.setAccountingDbDriver(param);
                                    break;
                                }
                                case ACCOUNTING_DB_URL: {
                                    this.setAccountingDbUrl(param);
                                    break;
                                }
                                case ACCOUNTING_DB_USER: {
                                    this.setAccountingDbUser(param);
                                    break;
                                }
                                case ACCOUNTING_DB_PASS: {
                                    this.setAccountingDbPass(param);
                                    break;
                                }
                                case DEBFILE: {
                                    this.setDebFile(param);
                                    break;
                                }
                                case DEBFILE_PATTERN: {
                                    this.setDebFilePattern(param);
                                    break;
                                }
                                case RUNTIME_THREADPOOL: {
                                    this.setThreadPool(TextCfg.getInt(param));
                                    break;
                                }
                                case REMOVE_JOB_THREADPOOL: {
                                    this.setRemoveThreadPool(TextCfg.getInt(param));
                                    break;
                                }
                                case ACCOUNTING_ON: {
                                    try {
                                        this.setAccountingOn(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + this.getAccountingOn() + " as default."));
                                    }
                                    break;
                                }
                                case ACCOUNTFILE_DIR: {
                                    if (param.length() == 0) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + "! Assuming '" + this.getAccountfileDir() + "'"));
                                        break;
                                    }
                                    this.setAccountfileDir(param);
                                    break;
                                }
                                case RCBACCOUNTING_ON: {
                                    try {
                                        this.setRcbAccountingOn(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + this.getRcbAccountingOn() + " as default."));
                                    }
                                    break;
                                }
                                case RCBACCOUNTFILEPATH: {
                                    if (param == null || param.length() == 0) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + "! Assuming '" + this.getRcbAccountfilePath() + "'"));
                                        break;
                                    }
                                    this.setRcbAccountfilePath(param);
                                    break;
                                }
                                case TRKAPIPATH: {
                                    this.setTrkApiPath(param);
                                    break;
                                }
                                case READ_RUNTIME_ON_RCF: {
                                    try {
                                        this.setReadRuntimeOnRcf(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + this.readRuntimeOnRcf() + " as default."));
                                    }
                                    break;
                                }
                                case AUTO_REMOVE_ON: {
                                    try {
                                        this.setAutoRemoveOn(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + this.getAutoRemoveOn() + " as default."));
                                    }
                                    break;
                                }
                                case ARCHIVE_ON: {
                                    try {
                                        this.setArchiveOn(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.warn((Object)("Invalid value '" + param + "' for parameter " + paramName + ": " + (Object)((Object)e) + ", use " + this.getArchiveOn() + " as default."));
                                    }
                                    break;
                                }
                                case ARCHIVE_CMD: {
                                    try {
                                        if (param.equalsIgnoreCase("N")) {
                                            this.setOnError("");
                                            break;
                                        }
                                        this.setArchiveCmd(param);
                                    }
                                    catch (ParameterException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case TIME_HOLDJOBRAM: {
                                    try {
                                        this.setTimeHoldJobRam(TextCfg.getInt(param));
                                    }
                                    catch (ParameterException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case SIZE_JOBHASH: {
                                    try {
                                        this.setSizeJobHash(TextCfg.getInt(param));
                                    }
                                    catch (ParameterException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case MAX_JS_DISPATCH: {
                                    this.setMaxJsDispatch(TextCfg.getInt(param));
                                    break;
                                }
                                case DEL_DB_JOB: {
                                    try {
                                        this.setDelDbJob(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case DEL_DB_EVENT: {
                                    try {
                                        this.setDelDbEvent(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case MAX_LOGPROT_LINES: {
                                    this.setMaxLogprotLines(TextCfg.getInt(param));
                                    break;
                                }
                                case KEEP_EMPTY_VARS: {
                                    try {
                                        TextEdiboss.setKeepEmptyVars(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                case KEEP_UNKNOWN_VARS: {
                                    try {
                                        TextEdiboss.setKeepUnknownVars(TextCfg.getBool(param));
                                    }
                                    catch (CfgException e) {
                                        log.error((Object)(e.getMessage() + " in line: " + lineNo + ", ignored"));
                                    }
                                    break;
                                }
                                default: {
                                    log.warn((Object)("unknown identifier: " + (Object)((Object)ident) + " in line " + line + ", ignored"));
                                }
                            }
                        }
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace((Object)"skip line");
                }
                line = br.readLine();
            }
        }
    }

    static {
        id.put("WAIT_REMOVE_JOB", Ident.WAIT_REMOVE_JOB);
        id.put("WAIT_REMOVE_EVENT", Ident.WAIT_REMOVE_EVENT);
        id.put("ON_ERROR", Ident.ON_ERROR);
        id.put("ON_RETRY_FULL", Ident.ON_RETRY_FULL);
        id.put("MASTER_EXEC_TIMEOUT", Ident.MASTER_EXEC_TIMEOUT);
        id.put("SLAVEPATH", Ident.SLAVE_PATH);
        id.put("TWINDOWPATH", Ident.TIMEWINDOW_PATH);
        id.put("RCCPATH", Ident.RCC_PATH);
        id.put("FDECLPATH", Ident.FCTN_PATH);
        id.put("JSLPATH", Ident.JSL_PATH);
        id.put("JOBPATH", Ident.JOB_PATH);
        id.put("LOGFILEPATH", Ident.LOGFILE_PATH);
        id.put("LICENSEPATH", Ident.LICENSE_PATH);
        id.put("PROTPOOLPATH", Ident.PROTPOOL_PATH);
        id.put("PROTFILE_DIR", Ident.PROTFILE_DIR);
        id.put("MASTER_SERVICE", Ident.SERVER_PORT);
        id.put("IPCLISTENQUEUEENTRIES", Ident.IPC_BACKLOG);
        id.put("IPCRWTIMEOUT", Ident.IPC_RW_TIMEOUT);
        id.put("IPCCONNECTTIMEOUT", Ident.IPC_CONNECT_TIMEOUT);
        id.put("IPCTCPNODELAY", Ident.IPC_NODELAY);
        id.put("LOAD_FETCH_SIZE", Ident.LOAD_FETCH_SIZE);
        id.put("DB_URL", Ident.DB_URL);
        id.put("DB_USER_NAME", Ident.DB_USER);
        id.put("DB_DRIVER", Ident.DB_DRIVER);
        id.put("DB_PASSWORD", Ident.DB_PASS);
        id.put("ACCOUNTING_IN_FILE", Ident.ACCOUNTING_IN_FILE);
        id.put("ACCOUNTING_IN_DB", Ident.ACCOUNTING_IN_DB);
        id.put("ACCOUNTING_DB_URL", Ident.ACCOUNTING_DB_URL);
        id.put("ACCOUNTING_DB_USER_NAME", Ident.ACCOUNTING_DB_USER);
        id.put("ACCOUNTING_DB_DRIVER", Ident.ACCOUNTING_DB_DRIVER);
        id.put("ACCOUNTING_DB_PASSWORD", Ident.ACCOUNTING_DB_PASS);
        id.put("DEBFILE_EDIMAN", Ident.DEBFILE);
        id.put("DEBFILE_PATTERN", Ident.DEBFILE_PATTERN);
        id.put("RUNTIME_THREADPOOL", Ident.RUNTIME_THREADPOOL);
        id.put("REMOVE_JOB_THREADPOOL", Ident.REMOVE_JOB_THREADPOOL);
        id.put("ACCOUNTING_ON", Ident.ACCOUNTING_ON);
        id.put("ACCOUNTFILE_DIR", Ident.ACCOUNTFILE_DIR);
        id.put("RCBACCOUNTING_ON", Ident.RCBACCOUNTING_ON);
        id.put("RCBACCOUNTFILEPATH", Ident.RCBACCOUNTFILEPATH);
        id.put("READ_RUNTIME_ON_RCF", Ident.READ_RUNTIME_ON_RCF);
        id.put("TRKAPIPATH", Ident.TRKAPIPATH);
        id.put("AUTO_REMOVE_ON", Ident.AUTO_REMOVE_ON);
        id.put("ARCHIVE_ON", Ident.ARCHIVE_ON);
        id.put("ARCHIVE_CMD", Ident.ARCHIVE_CMD);
        id.put("TIME_HOLDJOBRAM", Ident.TIME_HOLDJOBRAM);
        id.put("SIZE_JOBHASH", Ident.SIZE_JOBHASH);
        id.put("MAX_JS_DISPATCH", Ident.MAX_JS_DISPATCH);
        id.put("DEL_DB_JOB", Ident.DEL_DB_JOB);
        id.put("DEL_DB_EVENT", Ident.DEL_DB_EVENT);
        id.put("MAX_LOGPROT_LINES", Ident.MAX_LOGPROT_LINES);
        id.put("KEEP_EMPTY_VARS", Ident.KEEP_EMPTY_VARS);
        id.put("KEEP_UNKNOWN_VARS", Ident.KEEP_UNKNOWN_VARS);
    }

    private static enum Ident {
        WAIT_REMOVE_JOB,
        WAIT_REMOVE_EVENT,
        ON_ERROR,
        ON_RETRY_FULL,
        MASTER_EXEC_TIMEOUT,
        SLAVE_PATH,
        TIMEWINDOW_PATH,
        RCC_PATH,
        FCTN_PATH,
        JSL_PATH,
        JOB_PATH,
        LOGFILE_PATH,
        LICENSE_PATH,
        PROTPOOL_PATH,
        PROTFILE_DIR,
        SERVER_PORT,
        IPC_BACKLOG,
        IPC_RW_TIMEOUT,
        IPC_CONNECT_TIMEOUT,
        IPC_NODELAY,
        LOAD_FETCH_SIZE,
        DB_DRIVER,
        DB_URL,
        DB_USER,
        DB_PASS,
        ACCOUNTING_IN_FILE,
        ACCOUNTING_IN_DB,
        ACCOUNTING_DB_DRIVER,
        ACCOUNTING_DB_URL,
        ACCOUNTING_DB_USER,
        ACCOUNTING_DB_PASS,
        DEBFILE,
        DEBFILE_PATTERN,
        RUNTIME_THREADPOOL,
        REMOVE_JOB_THREADPOOL,
        ACCOUNTING_ON,
        ACCOUNTFILE_DIR,
        RCBACCOUNTING_ON,
        RCBACCOUNTFILEPATH,
        READ_RUNTIME_ON_RCF,
        TRKAPIPATH,
        AUTO_REMOVE_ON,
        ARCHIVE_ON,
        ARCHIVE_CMD,
        TIME_HOLDJOBRAM,
        SIZE_JOBHASH,
        MAX_JS_DISPATCH,
        DEL_DB_JOB,
        DEL_DB_EVENT,
        MAX_LOGPROT_LINES,
        KEEP_EMPTY_VARS,
        KEEP_UNKNOWN_VARS;

    }
}

