/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

class Time {
    private int h = -1;
    private int m = -1;
    private int s = -1;

    public Time(ClusterStream ois) throws IOException {
        this.h = ois.readInt();
        this.m = ois.readInt();
        this.s = ois.readInt();
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeInt(this.h);
        oos.writeInt(this.m);
        oos.writeInt(this.m);
    }

    public Time(int h, int m, int s) {
        this.h = h;
        this.m = m;
        this.s = s;
    }

    public boolean before(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setTime(date);
        if (this.h < c.get(11)) {
            return true;
        }
        if (this.h > c.get(11)) {
            return false;
        }
        if (this.m < c.get(12)) {
            return true;
        }
        if (this.m > c.get(12)) {
            return false;
        }
        return this.s < c.get(13);
    }

    public boolean after(Date date) {
        Date thisDate = this.getDate(date);
        return thisDate.after(date);
    }

    public Date getDate(Date from) {
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setTime(from);
        c.set(11, this.h);
        c.set(12, this.m);
        c.set(13, this.s);
        return c.getTime();
    }

    public String toString() {
        return "" + (this.h < 10 ? "0" : "") + this.h + ":" + (this.m < 10 ? "0" : "") + this.m + ":" + (this.s < 10 ? "0" : "") + this.s;
    }
}

