/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ParameterException;

public abstract class TrkApiPar {
    private static final int LEN_INTERN_ID = 16;
    private static final int LEN_HOST_NAME = 64;
    private static final int LEN_PATH_NAME = 255;
    public static final String TSIM_SENTINEL_CLIENT = "de.axway.aim.controller.master.account.TsimSentinelClient";
    public static final String JNDI_SENTINEL_CLIENT = "de.axway.common.sentinelrouter.utils.JndiSentinelClient";
    private String myStorageName = null;
    private String trkProductName = "TSIM";
    private String trkOvfFilename = "spool/trk2sentinel/TSIM_Overflow.trk";
    private int trkOvfFileSize = 128;
    private String trkLocalAddr = "";
    private String trkIpAddr;
    private String trkIpPort;
    private String trkIpAddr2;
    private String trkIpPort2;
    private int trkTrace = 0;
    private String trkTrcFilename;
    private int onInitAllJs;
    private int trkThrowEx = 0;
    private String wfTrackedObj;
    private String eoTrackedObj;
    private String javaSentinelClient = "de.axway.aim.controller.master.account.TsimSentinelClient";

    private static void checkLen(String name, String val, int maxLen) throws ParameterException {
        if (val != null && val.length() > 0) {
            if (val.length() > maxLen) {
                throw new ParameterException("Illegal value len == " + val.length() + " of parameter " + name + ", max: " + maxLen);
            }
        } else {
            throw new ParameterException("Parameter " + name + " is null or empty!");
        }
    }

    private static int parseCheckInt(String name, String val, int min, int max) throws ParameterException {
        int i;
        try {
            i = Integer.parseInt(val);
            if (i < min || i > max) {
                throw new ParameterException("Parameter " + name + ": value '" + val + "' out of range, min = " + min + ", max = " + max);
            }
        }
        catch (NumberFormatException e) {
            throw new ParameterException("Illegal int value '" + val + "' of parameter " + name + ", " + e, (Throwable)e);
        }
        return i;
    }

    public void setTrkThrowEx(String name, String val) throws ParameterException {
        this.trkThrowEx = TrkApiPar.parseCheckInt(name, val, 0, 1);
    }

    public void setTrkProductName(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 64);
        this.trkProductName = val;
    }

    public void setTrkLocalAddr(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 64);
        this.trkLocalAddr = val;
    }

    public void setTrkOvfFilename(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 255);
        this.trkOvfFilename = val;
    }

    public void setTrkIpAddr(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 64);
        this.trkIpAddr = val;
    }

    public void setTrkIpPort(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 16);
        this.trkIpPort = val;
    }

    public void setTrkIpAddr2(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 64);
        this.trkIpAddr2 = val;
    }

    public void setTrkIpPort2(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 16);
        this.trkIpPort2 = val;
    }

    public void setTrkTrace(String name, String val) throws ParameterException {
        this.trkTrace = TrkApiPar.parseCheckInt(name, val, 0, 4);
    }

    public void setTrkTrcFilename(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 255);
        this.trkTrcFilename = val;
    }

    public void setOnInitAllJs(String name, String val) throws ParameterException {
        this.onInitAllJs = TrkApiPar.parseCheckInt(name, val, 0, 1);
    }

    public void setWfTrackedObj(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 64);
        this.wfTrackedObj = val;
    }

    public void setEoTrackedObj(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 64);
        this.eoTrackedObj = val;
    }

    public void setMyStorageName(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 255);
        this.myStorageName = val;
    }

    public void setTrkOvfFileSize(String name, String val) throws ParameterException {
        this.trkOvfFileSize = TrkApiPar.parseCheckInt(name, val, 1, 1024);
    }

    public void setJavaSentinelClient(String name, String val) throws ParameterException {
        TrkApiPar.checkLen(name, val, 255);
        this.javaSentinelClient = val;
    }

    public int getTrkThrowEx() {
        return this.trkThrowEx;
    }

    public String getTrkProductName() {
        return this.trkProductName;
    }

    public String getTrkLocalAddr() {
        return this.trkLocalAddr;
    }

    public String getTrkOvfFilename() {
        return this.trkOvfFilename;
    }

    public String getTrkIpAddr() {
        return this.trkIpAddr;
    }

    public String getTrkIpPort() {
        return this.trkIpPort;
    }

    public String getTrkIpAddr2() {
        return this.trkIpAddr2;
    }

    public String getTrkIpPort2() {
        return this.trkIpPort2;
    }

    public int getTrkTrace() {
        return this.trkTrace;
    }

    public String getTrkTrcFilename() {
        return this.trkTrcFilename;
    }

    public int getOnInitAllJs() {
        return this.onInitAllJs;
    }

    public String getWfTrackedObj() {
        return this.wfTrackedObj;
    }

    public String getEoTrackedObj() {
        return this.eoTrackedObj;
    }

    public String getMyStorageName() {
        return this.myStorageName;
    }

    public int getTrkOvfFileSize() {
        return this.trkOvfFileSize;
    }

    public String getJavaSentinelClient() {
        return this.javaSentinelClient;
    }

    public boolean notSet(String val) {
        return val == null || val.length() == 0;
    }

    public void checkContent() throws ParameterException {
        StringBuilder buf = new StringBuilder();
        if (this.notSet(this.trkIpAddr)) {
            buf.append("trkIpAddr");
        }
        if (this.notSet(this.trkIpPort)) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("trkIpPort");
        }
        if (this.notSet(this.wfTrackedObj)) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("wfTrackedObj");
        }
        if (buf.length() > 0) {
            throw new ParameterException("TrkApiPar content invalid: undefined parameters: " + buf);
        }
    }
}

