/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.command;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.command.Cmd;
import de.axway.aim.controller.master.command.CmdAnswer;
import de.axway.aim.controller.master.command.SetEvtStormWall;
import de.axway.aim.controller.master.command.StormWallRule;
import de.axway.lockDaemon.LockException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClearEvtStormWall
extends Cmd {
    public ClearEvtStormWall(String host, int cmdType, String cmdName, int ubtNr, String initiator, String user, String[] args, CtrlDispAppl dispatcher) throws SQLException, LockException {
        super(host, cmdType, cmdName, ubtNr, initiator, user, args, dispatcher);
    }

    @Override
    public CmdAnswer execute() {
        if (this.args[0].equals("ALL")) {
            this.clearAllRules();
        } else {
            this.clearMatchingRules(this.convertToStormWallRule(this.args));
        }
        CmdAnswer answer = new CmdAnswer(0, this.cmdNo, 1, 63, null, null);
        return answer;
    }

    private StormWallRule convertToStormWallRule(String[] args) {
        StormWallRule rule = new StormWallRule();
        ArrayList<String> evtAttr = new ArrayList<String>();
        for (String arg : args) {
            if ("STOP_JOB".equals(arg) || "SUSPEND_JOB".equals(arg)) {
                rule.setAction(arg);
                continue;
            }
            if (arg.toUpperCase().contains("JOBNAME")) {
                rule.setJobName(arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            evtAttr.add(arg);
        }
        rule.setEvtAttr(evtAttr);
        return rule;
    }

    private void clearMatchingRules(StormWallRule rule) {
        StormWallRule i;
        Iterator<StormWallRule> iterator;
        String action = rule.getAction();
        String jobName = rule.getJobName();
        List<String> evtAttr = rule.getEvtAttr();
        boolean wasRemoved = false;
        if (jobName == null && (evtAttr == null || evtAttr.isEmpty())) {
            iterator = SetEvtStormWall.STORM_WALL_RULES.iterator();
            while (iterator.hasNext()) {
                i = iterator.next();
                if (!action.equals(i.getAction())) continue;
                iterator.remove();
                wasRemoved = true;
                log.info((Object)("Removed storm wall rule: " + i.toString() + ". Storm wall rules left: " + SetEvtStormWall.STORM_WALL_RULES.size()));
            }
        }
        if (jobName != null && (evtAttr == null || evtAttr.isEmpty())) {
            iterator = SetEvtStormWall.STORM_WALL_RULES.iterator();
            while (iterator.hasNext()) {
                i = iterator.next();
                if (!action.equals(i.getAction()) || !jobName.equals(i.getJobName())) continue;
                iterator.remove();
                wasRemoved = true;
                log.info((Object)("Removed storm wall rule: " + i.toString() + ". Storm wall rules left: " + SetEvtStormWall.STORM_WALL_RULES.size()));
            }
        }
        if (evtAttr != null && !evtAttr.isEmpty() && jobName == null) {
            iterator = SetEvtStormWall.STORM_WALL_RULES.iterator();
            while (iterator.hasNext()) {
                i = iterator.next();
                if (!action.equals(i.getAction()) || !evtAttr.equals(i.getEvtAttr())) continue;
                iterator.remove();
                wasRemoved = true;
                log.info((Object)("Removed storm wall rule: " + i.toString() + ". Storm wall rules left: " + SetEvtStormWall.STORM_WALL_RULES.size()));
            }
        }
        if (evtAttr != null && !evtAttr.isEmpty() && jobName != null) {
            iterator = SetEvtStormWall.STORM_WALL_RULES.iterator();
            while (iterator.hasNext()) {
                i = iterator.next();
                if (!action.equals(i.getAction()) || !jobName.equals(i.getJobName()) || !evtAttr.equals(i.getEvtAttr())) continue;
                iterator.remove();
                wasRemoved = true;
                log.info((Object)("Removed storm wall rule: " + i.toString() + ". Storm wall rules left: " + SetEvtStormWall.STORM_WALL_RULES.size()));
            }
        }
        if (!wasRemoved) {
            log.warn((Object)("No matching storm wall rule to remove: " + rule.toString() + ". Storm wall rules left: " + SetEvtStormWall.STORM_WALL_RULES.size()));
        }
    }

    private void clearAllRules() {
        SetEvtStormWall.STORM_WALL_RULES.clear();
    }
}

