/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.command;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.Globals;
import de.axway.aim.controller.master.command.CheckFCall;
import de.axway.aim.controller.master.command.ClearEvtStormWall;
import de.axway.aim.controller.master.command.CmdAnswer;
import de.axway.aim.controller.master.command.DoCmp;
import de.axway.aim.controller.master.command.JMStatus;
import de.axway.aim.controller.master.command.Match;
import de.axway.aim.controller.master.command.MatchChPrio;
import de.axway.aim.controller.master.command.MatchKill;
import de.axway.aim.controller.master.command.MatchRunJS;
import de.axway.aim.controller.master.command.MatchSuspend;
import de.axway.aim.controller.master.command.Reconfig;
import de.axway.aim.controller.master.command.SetEvtStormWall;
import de.axway.aim.controller.master.command.Shutdown;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.util.StringOp;
import de.axway.lockDaemon.LockException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Cmd {
    protected static Log log = LogFactory.getLog((String)"de.axway.aim.controller.master.command");
    protected int cmdType;
    protected String cmdName;
    protected String hostname;
    protected int cmdNo;
    protected boolean newCmdNo = false;
    protected String initiator;
    protected String user;
    protected String[] args;
    protected CtrlDispAppl dispatcher;
    protected ILogbook logbook;
    protected static Hashtable<Integer, String> idToName = new Hashtable();
    protected static Hashtable<String, Integer> nameToId = new Hashtable();

    protected Cmd(int cmdType, int cmdNo, String[] args, CtrlDispAppl dispatcher) throws SQLException, LockException {
        this(Globals.getLocalHostname(), cmdType, idToName.get(cmdType), cmdNo, Globals.getTxtEdiman(), Globals.getMasterUser(), args, dispatcher);
    }

    protected Cmd(String hostname, int cmdType, String cmdName, int cmdNo, String initiator, String user, String[] args, CtrlDispAppl dispatcher) throws SQLException, LockException {
        this.hostname = hostname;
        this.cmdType = cmdType;
        this.cmdName = cmdName;
        this.initiator = initiator;
        this.user = user;
        this.args = args;
        this.dispatcher = dispatcher;
        this.logbook = Logbook.getLogbook();
        log.debug((Object)"Command.<init> start:");
        if (cmdNo == 0) {
            this.cmdNo = (int)dispatcher.getNextCmdId();
            this.newCmdNo = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Command.<init>: created command ID: " + this.cmdNo));
            }
        } else {
            this.cmdNo = cmdNo;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Command.<init>: given command ID: " + this.cmdNo));
            }
        }
        this.logbook.command(this.initiator, this.cmdNo, this.user, this.hostname, this.cmdName, this.args);
    }

    public static Cmd create(String host, int cmdType, String cmdName, int cmdNo, String initiator, String user, String[] args, CtrlDispAppl dispatcher) throws SQLException, LockException {
        String cmdNameOK = idToName.get(cmdType);
        Cmd newCmd = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cmd.create start : " + cmdNo + ", cmdType:" + cmdType + ", cmdName: " + cmdName));
            if (args != null && log.isTraceEnabled()) {
                for (int i = 0; i < args.length; ++i) {
                    log.trace((Object)("Cmd.create: args[" + i + "] = '" + args[i] + "'"));
                }
            }
        }
        if (cmdNameOK == null) {
            throw new IllegalArgumentException("Unknown command code: " + cmdType);
        }
        if (!cmdNameOK.equals(cmdName)) {
            throw new IllegalArgumentException("Command name '" + cmdName + " does not match '" + cmdNameOK + "'.");
        }
        switch (cmdType) {
            case 66: {
                newCmd = new DoCmp(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 65: {
                newCmd = new JMStatus(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 3: {
                newCmd = new Reconfig(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 5: {
                newCmd = new Shutdown(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 55: {
                newCmd = new CheckFCall(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 49: {
                newCmd = new Match(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 50: {
                newCmd = new MatchKill(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 52: {
                newCmd = new MatchRunJS(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 51: {
                newCmd = new MatchSuspend(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 59: {
                newCmd = new MatchChPrio(host, cmdType, cmdName, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 62: {
                newCmd = new SetEvtStormWall(host, cmdType, cmdNameOK, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 63: {
                newCmd = new ClearEvtStormWall(host, cmdType, cmdNameOK, cmdNo, initiator, user, args, dispatcher);
                break;
            }
            case 61: {
                String msg = "Command not yet implemented: " + cmdType + " / " + cmdName;
                Logbook.getLogbook().error(msg);
                throw new IllegalArgumentException(msg);
            }
            default: {
                String msg = "Unknown command: " + cmdType + " / " + cmdName;
                Logbook.getLogbook().error(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cmd created: " + newCmd));
        }
        return newCmd;
    }

    public void setCmdType(int cmdType) {
        this.cmdType = cmdType;
    }

    public void setCmdName(String cmdName) {
        this.cmdName = cmdName;
    }

    public void setCmdNo(int cmdNo) {
        this.cmdNo = cmdNo;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public int getCmdType() {
        return this.cmdType;
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public int getCmdNo() {
        return this.cmdNo;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public String getUser() {
        return this.user;
    }

    public String[] getArgs() {
        return this.args;
    }

    public boolean waitForEnd() {
        return true;
    }

    public CmdAnswer executeAndLog() {
        CmdAnswer cAnswer = this.execute();
        this.logbook.commandEnd(this.initiator, cAnswer.getCmdNo(), this.user, this.hostname, this.cmdName, cAnswer.getLogData());
        return cAnswer;
    }

    public abstract CmdAnswer execute();

    public String getName() {
        String cn = this.getClass().getName();
        int idx = cn.lastIndexOf(46);
        if (idx != -1) {
            cn = cn.substring(idx + 1);
        }
        return cn;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Cmd: cmdType: ");
        buf.append(this.cmdType);
        buf.append(", cmdName: ");
        buf.append(this.cmdName);
        buf.append(", hostname: ");
        buf.append(this.hostname);
        buf.append(", cmdNo: ");
        buf.append(this.cmdNo);
        buf.append(", initiator: ");
        buf.append(this.initiator);
        buf.append(", user: ");
        buf.append(this.user);
        buf.append(", args: [");
        buf.append(StringOp.arrayToString((Object[])this.args));
        buf.append("], dispatcher: ");
        buf.append(this.dispatcher);
        return buf.toString();
    }

    public static String getName(int id) {
        return idToName.get(id);
    }

    public static int getId(String name) {
        return nameToId.get(name);
    }

    static {
        idToName.put(65, "JMSTATUS");
        idToName.put(3, "RECONFIG");
        idToName.put(5, "STOP");
        idToName.put(55, "CHECK_FCALL");
        idToName.put(54, "KILL_PROCESS");
        idToName.put(56, "RM_FILE");
        idToName.put(61, "EDIMAN_TRACE");
        idToName.put(49, "MATCH");
        idToName.put(51, "MATCH_SUSPEND");
        idToName.put(50, "MATCH_KILL");
        idToName.put(52, "MATCH_RUN_JS");
        idToName.put(63, "CLR_EvtStormWall");
        idToName.put(59, "MATCH_CHPRIO");
        idToName.put(62, "SET_EvtStormWall");
        idToName.put(66, "DO_CMP");
        Enumeration<Integer> codes = idToName.keys();
        while (codes.hasMoreElements()) {
            Integer code = codes.nextElement();
            nameToId.put(idToName.get(code), code);
        }
    }
}

