/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.command;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.command.Cmd;
import de.axway.aim.controller.master.command.CmdAnswer;
import de.axway.aim.controller.master.command.MatchSpec;
import de.axway.lockDaemon.LockException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Match
extends Cmd {
    private static final String MATCHED_MSG = "Matched: ";
    protected static Hashtable<Integer, Long[]> cmdIDTable = new Hashtable();
    protected static final boolean OLD_RESULT_MUST_EXIST = true;
    private static final String FMT_DISCARDED = "%10d|%s: ID-Table for CMP-ID=%d with %d entries discarded.";
    private static final String FMT_STORED = "%10d|%s: ID-Table for CMP-ID=%d with %d entries stored.";

    protected Match(String host, int cmdType, String cmdName, int ubtNr, String initiator, String user, String[] args, CtrlDispAppl dispatcher) throws SQLException, LockException {
        super(host, cmdType, cmdName, ubtNr, initiator, user, args, dispatcher);
    }

    @Override
    public CmdAnswer execute() {
        return this.execute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CmdAnswer execute(boolean resultMustExist) {
        CmdAnswer answer = null;
        String[] lines = null;
        String[] anyData = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        try {
            Long[] jobs;
            Hashtable<Integer, Long[]> hashtable;
            MatchSpec matchSpecification = new MatchSpec(this.args);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Match.execute: resultMustExist: " + resultMustExist + "\n" + matchSpecification));
            }
            if (resultMustExist) {
                hashtable = cmdIDTable;
                synchronized (hashtable) {
                    if (cmdIDTable.size() == 0) {
                        this.logbook.info(this.cmdName + ": ID-Table not available!");
                        throw new NoSuchFieldException("ID-Table entry " + this.cmdNo + " missing.");
                    }
                    jobs = cmdIDTable.get(this.cmdNo);
                    if (jobs == null) {
                        this.clearCmdIDTable(true);
                        throw new NoSuchFieldException("ID-Table entry " + this.cmdNo + " discarded.");
                    }
                }
            }
            jobs = this.dispatcher.executeMatch(matchSpecification);
            hashtable = cmdIDTable;
            synchronized (hashtable) {
                this.clearCmdIDTable(true);
                if (jobs != null && jobs.length != 0) {
                    cmdIDTable.put(this.cmdNo, jobs);
                    this.logbook.info(String.format(FMT_STORED, this.cmdNo, this.cmdName, this.cmdNo, jobs.length));
                }
            }
            if (log.isDebugEnabled()) {
                if (jobs != null) {
                    log.debug((Object)("Match.execute: " + jobs.length + " found."));
                } else {
                    log.debug((Object)"Match.execute: <null> returned!");
                }
            }
            lines = new String[jobs != null ? jobs.length + 1 : 1];
            anyData = new String[jobs != null ? jobs.length : 0];
            if (jobs != null) {
                lines[0] = MATCHED_MSG + jobs.length;
                for (int i = 0; i < jobs.length; ++i) {
                    lines[i + 1] = String.valueOf(jobs[i]);
                    anyData[i] = String.valueOf(jobs[i]);
                }
            } else {
                lines[0] = "Matched: 0";
            }
            answer = new CmdAnswer(0, this.cmdNo, anyData.length, this.cmdType, anyData, lines);
        }
        catch (Exception e) {
            log.error((Object)"Cannot execute match", (Throwable)e);
            lines = e.toString().split("\n");
            answer = new CmdAnswer(1, this.cmdNo, 1, this.cmdType, null, lines);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + answer));
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCmdIDTable(boolean printMessage) {
        Integer key = null;
        Long[] elements = null;
        Hashtable<Integer, Long[]> hashtable = cmdIDTable;
        synchronized (hashtable) {
            if (printMessage) {
                Enumeration<Integer> e = cmdIDTable.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    elements = cmdIDTable.get(key);
                    this.logbook.info(String.format(FMT_DISCARDED, this.cmdNo, this.cmdName, key, elements.length));
                }
            }
            cmdIDTable.clear();
        }
    }

    @Override
    public boolean waitForEnd() {
        return false;
    }
}

