/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.command;

public class MatchCmdValue<Type> {
    public static final char NOT_CHAR = '!';
    private Type minValue;
    private Type maxValue;
    private boolean doSelect = true;

    public MatchCmdValue(Type value, boolean doSelect) {
        this(value, value, doSelect);
    }

    public MatchCmdValue(Type minValue, Type maxValue, boolean doSelect) {
        this.minValue = minValue == null ? maxValue : minValue;
        if (this.minValue != maxValue) {
            this.maxValue = maxValue;
        }
        this.doSelect = doSelect;
    }

    public Type getValue() {
        return this.minValue;
    }

    public Type getMinValue() {
        return this.minValue;
    }

    public Type getMaxValue() {
        return this.maxValue;
    }

    public boolean isInclude() {
        return this.doSelect;
    }

    public boolean isExclude() {
        return !this.doSelect;
    }

    public boolean hasMinMax() {
        return this.minValue != null && this.maxValue != null && !this.minValue.equals(this.maxValue);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.doSelect ? "" : "!");
        if (this.hasMinMax()) {
            buf.append(this.minValue);
            buf.append('-');
            buf.append(this.maxValue);
        } else {
            buf.append(this.minValue);
        }
        return buf.toString();
    }

    public boolean isNumeric() {
        return this.minValue instanceof Integer || this.minValue instanceof Long;
    }
}

