/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.command;

import de.axway.aim.controller.master.command.MatchCmdParam;
import de.axway.aim.controller.master.command.MatchCmdValue;
import de.axway.lib.util.StringOp;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatchSpec {
    protected static Log log = LogFactory.getLog((String)"de.axway.aim.controller.master.command");
    private static final String PARTNER = "PARTNER";
    private static final String SENDER = "SENDER";
    private static final String RECEIVER = "RECEIVER";
    private static final String OBJ_CLASS = "OBJ_CLASS";
    private static final String JOBNAME = "JOBNAME";
    private static final String OBJECT_ID = "OBJECT_ID";
    private static final String JOB_ID = "JOB_ID";
    private static final String REFNO = "REFNO";
    private static final String STATUS = "STATUS";
    private static final String FROM_TIME = "FROM";
    private static final String TO_TIME = "TO";
    private static final String STRSTAT_UNDEFINED = "UNDEFINED";
    private static final String STRSTAT_ALL = "*";
    private static final String STRSTAT_OK = "OK";
    private static final String STRSTAT_ERROR = "ERROR";
    private static final String STRSTAT_RETRY = "RETRY";
    private static final String STRSTAT_STOPPED = "STOPPED";
    private static final String STRSTAT_SUSPEND = "SUSPEND";
    private static final String STRSTAT_READY = "READYTORUN";
    private static final String STRSTAT_ACTIVE = "ACTIVE";
    private MatchCmdParam partnerSpec = new MatchCmdParam("PARTNER");
    private MatchCmdParam senderSpec = new MatchCmdParam("SENDER");
    private MatchCmdParam receiverSpec = new MatchCmdParam("RECEIVER");
    private MatchCmdParam objClassSpec = new MatchCmdParam("OBJ_CLASS");
    private MatchCmdParam jobNameSpec = new MatchCmdParam("JOBNAME");
    private MatchCmdParam jobIdSpec = new MatchCmdParam("JOB_ID");
    private MatchCmdParam refNoSpec = new MatchCmdParam("REFNO");
    private MatchCmdParam jobStatus = new MatchCmdParam("STATUS");
    private MatchCmdValue<Date> fromDate = null;
    private MatchCmdValue<Date> toDate = null;
    private boolean suspended = false;

    private Date str2Date(String strDate, COMPLETE_TIME_OPTION opt) {
        Calendar cal = Calendar.getInstance();
        String[] ar = strDate.replace("\"", "").split("[. :]");
        int day = ar.length > 0 ? Integer.parseInt(ar[0]) : cal.get(5);
        int mon = ar.length > 1 ? Integer.parseInt(ar[1]) - 1 : cal.get(2);
        int year = ar.length > 2 ? Integer.parseInt(ar[2]) : cal.get(1);
        int hour = ar.length > 3 ? Integer.parseInt(ar[3]) : this.completeTime(11, opt, cal);
        int min = ar.length > 4 ? Integer.parseInt(ar[4]) : this.completeTime(12, opt, cal);
        int sec = ar.length > 5 ? Integer.parseInt(ar[5]) : this.completeTime(13, opt, cal);
        cal.set(year, mon, day, hour, min, sec);
        return cal.getTime();
    }

    private int completeTime(int field, COMPLETE_TIME_OPTION opt, Calendar cal) {
        if (opt == COMPLETE_TIME_OPTION.COMPLETE_TIME_TO_LOWER) {
            return 0;
        }
        if (opt == COMPLETE_TIME_OPTION.COMPLETE_TIME_TO_UPPER) {
            if (field == 11) {
                return 23;
            }
            return 59;
        }
        return cal.get(field);
    }

    private int strStat2Status(String strStat) {
        if (STRSTAT_UNDEFINED.equals(strStat) || STRSTAT_ALL.equals(strStat)) {
            return 0;
        }
        if (STRSTAT_OK.equals(strStat)) {
            return 4;
        }
        if (STRSTAT_ERROR.equals(strStat)) {
            return 2;
        }
        if (STRSTAT_RETRY.equals(strStat)) {
            return 3;
        }
        if (STRSTAT_STOPPED.equals(strStat)) {
            return 6;
        }
        if (STRSTAT_SUSPEND.equals(strStat)) {
            this.suspended = true;
        } else {
            if (STRSTAT_READY.equals(strStat)) {
                return 1;
            }
            if (STRSTAT_ACTIVE.equals(strStat)) {
                return 5;
            }
        }
        return -1;
    }

    public MatchSpec(String[] args) {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("MatchSpec.parsing: " + args[i]));
            }
            String[] keyNVals = args[i].split("=");
            String key = keyNVals[0];
            String[] vals = keyNVals.length < 2 ? new String[]{} : (key.equals(FROM_TIME) || key.equals(TO_TIME) ? new String[]{keyNVals[1]} : keyNVals[1].split(" "));
            if (log.isDebugEnabled()) {
                log.debug((Object)("MatchSpec.match key: " + key));
            }
            for (int j = 0; j < vals.length; ++j) {
                MatchCmdValue<Object> oneVal;
                boolean incl;
                if (vals[j] == null || vals[j].length() <= 0) continue;
                if (vals[j].charAt(0) == '!') {
                    incl = false;
                    vals[j] = vals[j].substring(1);
                } else {
                    incl = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MatchSpec.match value: include: " + incl + ", val:" + vals[j]));
                }
                if (key.equals(PARTNER)) {
                    oneVal = new MatchCmdValue<String>(vals[j], incl);
                    this.partnerSpec.add(oneVal);
                    continue;
                }
                if (key.equals(SENDER)) {
                    oneVal = new MatchCmdValue<String>(vals[j], incl);
                    this.senderSpec.add(oneVal);
                    continue;
                }
                if (key.equals(RECEIVER)) {
                    oneVal = new MatchCmdValue<String>(vals[j], incl);
                    this.receiverSpec.add(oneVal);
                    continue;
                }
                if (key.equals(OBJ_CLASS)) {
                    oneVal = new MatchCmdValue<String>(vals[j], incl);
                    this.objClassSpec.add(oneVal);
                    continue;
                }
                if (key.equals(JOBNAME)) {
                    oneVal = new MatchCmdValue<String>(vals[j], incl);
                    this.jobNameSpec.add(oneVal);
                    continue;
                }
                if (key.equals(OBJECT_ID) || key.equals(JOB_ID)) {
                    int idx;
                    if (vals[j].startsWith("\"")) {
                        int end = vals[j].length();
                        if (end > 1 && vals[j].endsWith("\"")) {
                            --end;
                        }
                        vals[j] = vals[j].substring(1, end);
                    }
                    oneVal = (idx = vals[j].indexOf(45)) != -1 ? new MatchCmdValue<Long>(Long.valueOf(vals[j].substring(0, idx)), Long.valueOf(vals[j].substring(idx + 1)), incl) : new MatchCmdValue<Long>(Long.valueOf(vals[j]), incl);
                    this.jobIdSpec.add(oneVal);
                    continue;
                }
                if (key.equals(REFNO)) {
                    oneVal = new MatchCmdValue<String>(vals[j], incl);
                    this.refNoSpec.add(oneVal);
                    continue;
                }
                if (key.equals(STATUS)) {
                    int jobStat = this.strStat2Status(vals[j]);
                    if (jobStat == 0) {
                        oneVal = new MatchCmdValue<Integer>(0, 6, incl);
                        this.jobStatus.add(oneVal);
                        continue;
                    }
                    if (jobStat == -1) continue;
                    oneVal = new MatchCmdValue<Integer>(jobStat, incl);
                    this.jobStatus.add(oneVal);
                    continue;
                }
                if (key.equals(FROM_TIME)) {
                    this.fromDate = new MatchCmdValue<Date>(this.str2Date(vals[j], COMPLETE_TIME_OPTION.COMPLETE_TIME_TO_LOWER), incl);
                    continue;
                }
                if (!key.equals(TO_TIME)) continue;
                this.toDate = new MatchCmdValue<Date>(this.str2Date(vals[j], COMPLETE_TIME_OPTION.COMPLETE_TIME_TO_UPPER), incl);
            }
        }
    }

    public MatchCmdParam getPartnerSpec() {
        return this.partnerSpec;
    }

    public MatchCmdParam getSenderSpec() {
        return this.senderSpec;
    }

    public MatchCmdParam getReceiverSpec() {
        return this.receiverSpec;
    }

    public MatchCmdParam getObjClassSpec() {
        return this.objClassSpec;
    }

    public MatchCmdParam getJobNameSpec() {
        return this.jobNameSpec;
    }

    public MatchCmdParam getJobIdSpec() {
        return this.jobIdSpec;
    }

    public MatchCmdParam getRefNoSpec() {
        return this.refNoSpec;
    }

    public MatchCmdParam getJobStatus() {
        return this.jobStatus;
    }

    public MatchCmdValue<Date> getFromDate() {
        return this.fromDate;
    }

    public MatchCmdValue<Date> getToDate() {
        return this.toDate;
    }

    public boolean getSuspended() {
        return this.suspended;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.partnerSpec.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("partnerSpec: ");
            buf.append(StringOp.arrayToString((Object[])this.partnerSpec.toArray()));
        }
        if (this.senderSpec.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("senderSpec: ");
            buf.append(StringOp.arrayToString((Object[])this.senderSpec.toArray()));
        }
        if (this.receiverSpec.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("receiverSpec: ");
            buf.append(StringOp.arrayToString((Object[])this.receiverSpec.toArray()));
        }
        if (this.objClassSpec.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("objClassSpec: ");
            buf.append(StringOp.arrayToString((Object[])this.objClassSpec.toArray()));
        }
        if (this.jobNameSpec.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("jobNameSpec: ");
            buf.append(StringOp.arrayToString((Object[])this.jobNameSpec.toArray()));
        }
        if (this.jobIdSpec.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("jobIdSpec: ");
            buf.append(StringOp.arrayToString((Object[])this.jobIdSpec.toArray()));
        }
        if (this.refNoSpec.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("refNoSpec: ");
            buf.append(StringOp.arrayToString((Object[])this.refNoSpec.toArray()));
        }
        if (this.jobStatus.size() > 0) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("jobStatus: ");
            buf.append(StringOp.arrayToString((Object[])this.jobStatus.toArray()));
        }
        buf.append(", suspended: ");
        buf.append(this.suspended);
        if (this.fromDate != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("fromDate: ");
            buf.append(this.fromDate);
        }
        if (this.toDate != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("toDate: ");
            buf.append(this.toDate);
        }
        return "MatchSpec:" + buf;
    }

    private static enum COMPLETE_TIME_OPTION {
        COMPLETE_TIME_TO_LOWER,
        COMPLETE_TIME_TO_UPPER,
        COMPLETE_TIME_TO_CURRENT;

    }
}

