/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.ConvertException;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.ISchemahandler;
import de.axway.aim.controller.master.convert.IntegerColumnDescription;
import de.axway.aim.controller.master.convert.PreparedStatementFactory;
import de.axway.aim.controller.master.convert.TableDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsciiToJdbcHandler
implements ISchemahandler {
    protected static final Log LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.convert");
    private TableDescription tableDescription;
    private PreparedStatement statement = null;
    private Connection connection;
    private String tableName;
    private int maxBatchCount;
    private int rowIndex;
    private String tablePostFix = "";
    private final int fMaxFetchSize;

    public AsciiToJdbcHandler(Connection maxConnection, int paramMaxBatchCount, int maxFetchSize) throws ConvertException {
        this.maxBatchCount = paramMaxBatchCount;
        this.connection = maxConnection;
        this.fMaxFetchSize = maxFetchSize;
        try {
            maxConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
    }

    @Override
    public void close() throws ConvertException {
    }

    @Override
    public void handleTableEnd(IRowset rowSet) throws ConvertException {
        try {
            this.statement.executeBatch();
            this.statement.close();
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        System.out.println(this.rowIndex + " entries");
    }

    @Override
    public void handleTableRow(Object[] rowDataArray) throws ConvertException {
        List<IColumnDescription> columnDescriptions = this.tableDescription.getColumnDescriptions();
        for (int i = 0; i < columnDescriptions.size(); ++i) {
            Object value;
            IColumnDescription columnDescription = columnDescriptions.get(i);
            try {
                value = rowDataArray[i];
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new Error(t);
            }
            try {
                if (columnDescription instanceof IntegerColumnDescription) {
                    if (value == null) {
                        value = -1;
                    }
                    this.statement.setObject(i + 1, value);
                    continue;
                }
                if (value == null) {
                    this.statement.setString(i + 1, null);
                    continue;
                }
                this.statement.setString(i + 1, value.toString());
                continue;
            }
            catch (SQLException e) {
                throw new ConvertException("error table: " + this.tableName + " col: " + columnDescription.getName() + " type: " + columnDescription.getClass().getName() + " valtype: " + value.getClass().getName() + " val: " + value);
            }
        }
        try {
            this.statement.addBatch();
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        ++this.rowIndex;
    }

    @Override
    public void handleTableStart(IRowset rowSet) throws ConvertException {
        this.rowIndex = 0;
        this.tableDescription = rowSet.getTableDescription();
        this.tableName = this.tableDescription.getName().toUpperCase().replaceAll("\\.", "_") + this.tablePostFix;
        String insertStatement = "insert into " + this.tableName;
        List<IColumnDescription> columnDescriptions = this.tableDescription.getColumnDescriptions();
        String colIdentifiers = "";
        String tokens = "";
        for (int i = 0; i < columnDescriptions.size(); ++i) {
            if (i != 0) {
                colIdentifiers = colIdentifiers + ", ";
                tokens = tokens + ", ";
            }
            colIdentifiers = colIdentifiers + columnDescriptions.get(i).getName();
            tokens = tokens + "?";
        }
        insertStatement = insertStatement + "(" + colIdentifiers + ") values(" + tokens + ")";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)insertStatement);
        }
        PreparedStatementFactory preparedStatementFactory = new PreparedStatementFactory(this.connection, this.maxBatchCount, this.fMaxFetchSize);
        try {
            this.statement = preparedStatementFactory.prepareStatement(insertStatement);
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
    }

    public void setTablePostFix(String paramTablePostFix) {
        this.tablePostFix = paramTablePostFix;
    }
}

