/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.Rowset;
import de.axway.aim.controller.master.convert.TableDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttrStringsRowset
extends Rowset {
    private ArrayList<Object[]> rowDataBuffer = new ArrayList();
    private TableDescription fieldTableDescription;

    public AttrStringsRowset(TableDescription tableDescription, File dataDir) throws Exception {
        super(tableDescription, dataDir);
        this.rowDataHash = null;
        this.fieldTableDescription = tableDescription;
    }

    @Override
    public boolean next() throws Exception {
        Pattern idPattern = Pattern.compile("\\s*ID\\s*=\\s*(\\S+)\\s*");
        if (this.rowDataBuffer.size() > 0) {
            this.rowDataHash = this.rowDataBuffer.remove(0);
            return true;
        }
        int lineNr = 0;
        String line = this.br.readLine();
        while (line != null) {
            Matcher idMatcher = idPattern.matcher(line);
            if (idMatcher.matches()) {
                this.isHeader = false;
                if (this.rs.getExpectedEntries() > 0) {
                    String stringId = idMatcher.group(1).trim().replaceFirst("^\"(.*)\"", "$1");
                    line = this.br.readLine();
                    String parentId = line.trim().replaceFirst("^\"(.*)\"", "$1");
                    line = this.br.readLine();
                    String typ = line.trim().replaceFirst("^\"(.*)\"", "$1");
                    line = this.br.readLine();
                    int noS = Integer.parseInt(line.trim());
                    int part = 0;
                    for (int pairIndex = 0; pairIndex < noS; ++pairIndex) {
                        String valueR;
                        String valueL;
                        line = this.br.readLine();
                        String attr = line.trim();
                        line = this.br.readLine();
                        String anykey = valueL = line.substring(2);
                        line = this.br.readLine();
                        String anyvalue = valueR = line.substring(2);
                        Object[] lRowDataHash = new Object[this.fieldTableDescription.getColumnDescriptions().size()];
                        int x = 0;
                        lRowDataHash[x++] = stringId;
                        lRowDataHash[x++] = ++part;
                        lRowDataHash[x++] = parentId;
                        lRowDataHash[x++] = typ;
                        lRowDataHash[x++] = attr;
                        lRowDataHash[x++] = anykey;
                        lRowDataHash[x++] = anyvalue;
                        lRowDataHash[x++] = valueL;
                        this.rowDataBuffer.add(lRowDataHash);
                    }
                    int size = this.rowDataBuffer.size();
                    if (size == 0) {
                        return false;
                    }
                    this.rowDataHash = this.rowDataBuffer.remove(0);
                    return true;
                }
            } else if (!this.isHeader) {
                if (line.matches("^\\s*(#.*)?$")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ignore line " + lineNr + ": " + line));
                    }
                } else {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("error at line " + lineNr + ": " + line));
                    }
                    throw new Exception("parse error");
                }
            }
            line = this.br.readLine();
            ++lineNr;
        }
        return false;
    }
}

