/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.lib.CfgJobStepRcReaction;
import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.CfgRcValue;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.cfg.CfgJobStep;
import de.axway.aim.controller.master.cfg.TextCfgRc;
import de.axway.aim.controller.master.cfg.TextEdiboss;
import de.axway.aim.controller.master.convert.Converter;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class ConverterA2J
extends Converter {
    private static final String[][] FALL_BACK_RC_REACTION = new String[][]{{"OK", "echo \"Missing job configuration on conversion C==>J.\""}, {"NOT_OK", "echo \"Missing job_configuration on conversion C==>J.\""}};
    private static final int BIT_SUSP = 4;
    private static final int BIT_SEQUENTIAL = 64;
    private static final int BIT_ACCOUNTING_ON = 16;
    private static final int BIT_ARCHIVE = 4;
    private static final int BIT_KEEP = 8;

    public ConverterA2J(int paramMaxBatchCount, int maxFetchSize) throws Exception {
        super(paramMaxBatchCount, maxFetchSize);
    }

    public void convertcAsciiToJJdbc() throws Exception {
        this.userInfo("convertcAsciiToJJdbc start");
        Date start = new Date();
        boolean isAutocommitEnabled = false;
        this.sqlExec("dropTmpTables.sql", false, isAutocommitEnabled);
        this.sqlExec("createTmpTables.sql", true, isAutocommitEnabled);
        this.dbCreate();
        this.initATOJCfg();
        this.cAsciiDbImport();
        this.genFunccallIndex();
        this.generateCtrlCfgJslIds();
        this.ctrlCfgJslPrepare();
        this.ctrlCfgJslPrepareAccountingOn();
        this.ctrlCfgJslPrepare3();
        this.ctrlCfgJslAccUsrcol();
        this.jselectAsciiPrepare();
        this.jobflags();
        this.jobstepflags();
        boolean isAutocommitEnabled2 = true;
        this.sqlExec("cascii2jjdbc.sql", true, isAutocommitEnabled2);
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
        this.readCtrlCfgJsRcReactionData();
        this.checkAssignValue();
        this.checkEmptyObjectPath();
        this.checkLostJselectEntries();
        this.checkEmptyEventParameterNames();
        this.checkLostObjectEntries();
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " convertcAsciiToJJdbc "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " convertcAsciiToJJdbc end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLostObjectEntries() throws SQLException {
        String selectStatementString = "select   OBJECT_NEW_TMP.OBJECT_ID,   OBJECT_NEW_TMP.JOB_ID from OBJECT_NEW_TMP left join JOBS_NEW_TMP on OBJECT_NEW_TMP.JOB_ID = JOBS_NEW_TMP.JOB_ID where JOBS_NEW_TMP.JOB_ID is null";
        try (Statement selectStatement = this.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal objectId = resultSet.getBigDecimal(colIndex++);
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                LOG.warn((Object)("Attention: Missing job entry (job_id=" + jobId + ") for object (object_id=" + objectId + ")! - Check manually."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAssignValue() throws SQLException {
        String selectStatementString = " select distinct  JOBSTEPS_NEW_TMP.JOB_ID,  JOBSTEPS_NEW_TMP.SEQUENCE_NO,  JOBSTEPS_NEW_TMP.FUNCTION_CLASS_NAME,  STRINGS_NEW_TMP.STRING_ID,  STRINGS_NEW_TMP.NAME,  STRINGS_NEW_TMP.STR_INDEX from JOBSTEPS_NEW_TMP,  STRINGS_NEW_TMP where  JOBSTEPS_NEW_TMP.JS_ASSIGNMENT_ID = STRINGS_NEW_TMP.STRING_ID and  STRINGS_NEW_TMP.VALUE is null";
        try (Statement selectStatement = this.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                BigDecimal sequenceNo = resultSet.getBigDecimal(colIndex++);
                String functionClassName = resultSet.getString(colIndex++);
                BigDecimal stringId = resultSet.getBigDecimal(colIndex++);
                String name = resultSet.getString(colIndex++);
                BigDecimal strIndex = resultSet.getBigDecimal(colIndex++);
                LOG.warn((Object)("Attention: Empty assign value in 'strings.new' (StringId=" + stringId + ", name=" + name + ", str_index=" + strIndex + ") 'jobsteps.new' (jobId=" + jobId + ", sequenceNo=" + sequenceNo + ", function_class_name=" + functionClassName + "! - Check manually."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEmptyObjectPath() throws SQLException {
        String selectStatementString = "select OBJECT_ID, COMPONENT_NO from OBJCOMP_NEW_TMP where COMPONENT_ACCESSPATH is null";
        try (Statement selectStatement = this.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal objectId = resultSet.getBigDecimal(colIndex++);
                BigDecimal componentNo = resultSet.getBigDecimal(colIndex++);
                LOG.warn((Object)("Attention: Empty COMPONENT_ACCESSPATH in 'objcomp.new' (ObjectId=" + objectId + ", ComponentNo=" + componentNo + ")! - Check manually."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLostJselectEntries() throws SQLException {
        String selectStatementString = "select\tJOBS_NEW_TMP.JOB_ID,\tJOBS_NEW_TMP.JOB_NAME from JOBS_NEW_TMP left join CFG_JSELECT_NEW_TMP on CFG_JSELECT_NEW_TMP.Jselect_ID=JOBS_NEW_TMP.JSELECT_ID where CFG_JSELECT_NEW_TMP.Jselect_ID is null";
        try (Statement selectStatement = this.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                String jobName = resultSet.getString(colIndex++);
                LOG.warn((Object)("Attention: Missing j_select configuration for job " + jobName + " (JobId=" + jobId + ")! - Check manually."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEmptyEventParameterNames() throws SQLException {
        String selectStatementString = "SELECT  EVENT_NEW_TMP.EVENT_ID,  EVENT_NEW_TMP.Params_ID,  STRINGS_NEW_TMP.str_index FROM STRINGS_NEW_TMP, EVENT_NEW_TMP WHERE  EVENT_NEW_TMP.Params_ID = STRINGS_NEW_TMP.string_id and  STRINGS_NEW_TMP.name is null";
        try (Statement selectStatement = this.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal eventId = resultSet.getBigDecimal(colIndex++);
                BigDecimal stringId = resultSet.getBigDecimal(colIndex++);
                BigDecimal index = resultSet.getBigDecimal(colIndex++);
                LOG.warn((Object)("Attention: Event parameter key name <null> found: eventId=" + eventId + "/ stringId=" + stringId + "/ index=" + index + " - Ignored!"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobflags() throws Exception {
        Date start = new Date();
        String selectStatementString = "select JOBS_NEW_TMP.JOB_ID, JOBS_NEW_TMP.JOB_STATUS, JOBS_NEW_TMP.ACCBITS, OBJECT_NEW_TMP.OBJECT_STATUS from JOBS_NEW_TMP, OBJECT_NEW_TMP where JOBS_NEW_TMP.JOB_ID=OBJECT_NEW_TMP.JOB_ID";
        String insertStatementString = "insert into tmp_jobflags (ID, SEQ, SUSP, JOBSTATUS) values (?,?,?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                BigDecimal jobStatus = resultSet.getBigDecimal(colIndex++);
                BigDecimal accBits = resultSet.getBigDecimal(colIndex++);
                BigDecimal cobjectStatus = resultSet.getBigDecimal(colIndex++);
                Integer seq = (accBits.intValue() & 0x40) == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
                Integer susp = (jobStatus.intValue() & 4) == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
                Integer jjobStatus = Job.cToJavaStatus((int)cobjectStatus.intValue());
                int varIndex = 1;
                insertStatement.setObject(varIndex++, jobId);
                insertStatement.setObject(varIndex++, seq);
                insertStatement.setObject(varIndex++, susp);
                insertStatement.setObject(varIndex++, jjobStatus);
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " jobflags "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + "jobflags end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobstepflags() throws Exception {
        Date start = new Date();
        String selectStatementString = "select\tJOBSTEPS_NEW_TMP.job_id,\tJOBSTEPS_NEW_TMP.sequence_no,\tJOBSTEPS_NEW_TMP.RETRY_COUNTER,\tJOBSTEPS_NEW_TMP.jobstep_status,   JOBSTEPS_NEW_TMP.REAL_WAKEUPTIME,   JOBSTEPS_NEW_TMP.appl_message from JOBSTEPS_NEW_TMP, (      SELECT job_id, sequence_no, max(RETRY_COUNTER) as max_RETRY_COUNTER       from JOBSTEPS_NEW_TMP       group by job_id, sequence_no      ) tlast_retry where JOBSTEPS_NEW_TMP.job_id=tlast_retry.job_id and       JOBSTEPS_NEW_TMP.sequence_no=tlast_retry.sequence_no and       JOBSTEPS_NEW_TMP.RETRY_COUNTER=tlast_retry.max_RETRY_COUNTER";
        String insertStatementString = "insert into tmp_jobstepflags ( JOB_ID, SEQUENCE_NO, RETRY_COUNTER, jobstep_status, REAL_WAKEUPTIME, JS_SUSPENDED, JS_TERMINATED, RCBLOG ) values (?,?,?,?,?,?,?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                BigDecimal sequenceNo = resultSet.getBigDecimal(colIndex++);
                BigDecimal retryCounter = resultSet.getBigDecimal(colIndex++);
                BigDecimal jobstepStatus = resultSet.getBigDecimal(colIndex++);
                BigDecimal realWakeuptime = resultSet.getBigDecimal(colIndex++);
                BigDecimal applMessage = resultSet.getBigDecimal(colIndex++);
                Integer jsSuspended = (jobstepStatus.intValue() & 4) == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
                Integer jsTerminated = (jobstepStatus.intValue() & 0x10) == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
                Integer rcblog = (applMessage.intValue() & 0x800) == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
                int varIndex = 1;
                insertStatement.setObject(varIndex++, jobId);
                insertStatement.setObject(varIndex++, sequenceNo);
                insertStatement.setObject(varIndex++, retryCounter);
                insertStatement.setObject(varIndex++, jobstepStatus);
                insertStatement.setObject(varIndex++, realWakeuptime);
                insertStatement.setObject(varIndex++, jsSuspended);
                insertStatement.setObject(varIndex++, jsTerminated);
                insertStatement.setObject(varIndex++, rcblog);
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + "jobstepflags "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + "jobstepflags end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genFunccallIndex() throws Exception {
        Date start = new Date();
        String selectStatementString = "select JOB_ID, JS_SEQUENCE_NO, JS_CURR_RETRY, FC_SEQUENCE_NO, FC_CURR_RETRY, FCTN_CALL_LEVEL from FUNCCALL_NEW_TMP order by JOB_ID, JS_SEQUENCE_NO, JS_CURR_RETRY, FC_SEQUENCE_NO, FC_CURR_RETRY, FCTN_CALL_LEVEL";
        String insertStatementString = "insert into tmp_funccall_index( JOB_ID, JS_SEQUENCE_NO, JS_CURR_RETRY, FC_SEQUENCE_NO, FC_CURR_RETRY, FCTN_CALL_LEVEL, fc_index) values (?,?,?,?,?,?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            Integer fcIndex = 1;
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                BigDecimal jsSequenceNo = resultSet.getBigDecimal(colIndex++);
                BigDecimal jsCurrRetry = resultSet.getBigDecimal(colIndex++);
                BigDecimal fcSequenceNo = resultSet.getBigDecimal(colIndex++);
                BigDecimal fcCurrRetry = resultSet.getBigDecimal(colIndex++);
                BigDecimal fctnCallLevel = resultSet.getBigDecimal(colIndex++);
                int varIndex = 1;
                insertStatement.setObject(varIndex++, jobId);
                insertStatement.setObject(varIndex++, jsSequenceNo);
                insertStatement.setObject(varIndex++, jsCurrRetry);
                insertStatement.setObject(varIndex++, fcSequenceNo);
                insertStatement.setObject(varIndex++, fcCurrRetry);
                insertStatement.setObject(varIndex++, fctnCallLevel);
                int n = varIndex++;
                Integer n2 = fcIndex;
                Integer n3 = fcIndex = Integer.valueOf(fcIndex + 1);
                insertStatement.setObject(n, n2);
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " genFunccallIndex "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " genFunccallIndex end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCtrlCfgJslIds() throws Exception {
        Date start = new Date();
        String selectStatementString = "select JOB_ID, JSELECT_ID from JOBS_NEW_TMP";
        String insertStatementString = "insert into tmp_CtrlCfgJslId (ID, JOB_ID, JSELECT_ID) values (?,?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            Integer ctrlJslId = 1;
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                BigDecimal jSelectId = resultSet.getBigDecimal(colIndex++);
                int varIndex = 1;
                int n = varIndex++;
                Integer n2 = ctrlJslId;
                Integer n3 = ctrlJslId = Integer.valueOf(ctrlJslId + 1);
                insertStatement.setObject(n, n2);
                insertStatement.setObject(varIndex++, jobId);
                insertStatement.setObject(varIndex++, jSelectId);
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " generateCtrlCfgJslIds"));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " generateCtrlCfgJslIds end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ctrlCfgJslAccUsrcol() throws Exception {
        Date start = new Date();
        String selectStatementString = "select STRING_ID, ATTR, ANYVALUE from ATTRSTRINGS_NEW_TMP, CFG_JSELECT_NEW_TMP where ATTRSTRINGS_NEW_TMP.STRING_ID=CFG_JSELECT_NEW_TMP.ACC_USRCOL_ID order by STRING_ID, PART";
        String insertStatementString = "insert into tmp_cfgjsl_accusrcol (string_id, acc_usrcol) values (?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            BigDecimal currStringId = null;
            String currAccUsrCol = null;
            while (resultSet.next()) {
                int colIndex = 1;
                BigDecimal stringId = resultSet.getBigDecimal(colIndex++);
                String attr = resultSet.getString(colIndex++);
                String anyValue = resultSet.getString(colIndex++);
                String attr1 = attr.split(" ")[0];
                if (currStringId == null || stringId.intValue() != currStringId.intValue()) {
                    if (currStringId != null) {
                        int varIndex = 1;
                        insertStatement.setBigDecimal(varIndex++, currStringId);
                        insertStatement.setString(varIndex++, currAccUsrCol);
                        insertStatement.addBatch();
                    }
                    currStringId = BigDecimal.valueOf(stringId.intValue());
                    currAccUsrCol = "";
                } else {
                    currAccUsrCol = currAccUsrCol + " ";
                }
                currAccUsrCol = currAccUsrCol + attr1 + "=" + anyValue;
            }
            if (currStringId != null) {
                int varIndex = 1;
                insertStatement.setObject(varIndex++, currStringId);
                insertStatement.setObject(varIndex++, currAccUsrCol);
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " ctrlCfgJslAccUsrcol "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " ctrlCfgJslAccUsrcol end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ctrlCfgJslPrepare() throws Exception {
        Date start = new Date();
        Integer intValue = -1;
        String selectStatementString = "select JSELECT_ID, param, STRING_ID, ANYKEY, ANYVALUE from ( select CFG_JSELECT_NEW_TMP.JSELECT_ID, 'ON_ERROR' as param, ATTRSTRINGS_NEW_TMP.STRING_ID,        ATTRSTRINGS_NEW_TMP.PART, ATTRSTRINGS_NEW_TMP.ANYKEY, ATTRSTRINGS_NEW_TMP.ANYVALUE from CFG_JSELECT_NEW_TMP left join ATTRSTRINGS_NEW_TMP on CFG_JSELECT_NEW_TMP.ON_ERROR_ID=ATTRSTRINGS_NEW_TMP.STRING_ID union select CFG_JSELECT_NEW_TMP.JSELECT_ID, 'ON_RETRY' as param, ATTRSTRINGS_NEW_TMP.STRING_ID,        ATTRSTRINGS_NEW_TMP.PART, ATTRSTRINGS_NEW_TMP.ANYKEY, ATTRSTRINGS_NEW_TMP.ANYVALUE from CFG_JSELECT_NEW_TMP left join ATTRSTRINGS_NEW_TMP on CFG_JSELECT_NEW_TMP.ON_RETRY_FULL_ID=ATTRSTRINGS_NEW_TMP.STRING_ID ) s order by JSELECT_ID, param, part";
        String insertStatementString = "insert into tmp_jselectAttr (JSELECT_ID, param, STRING_ID, value, intValue) values (?,?,?,?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            Object currJselectId = null;
            String currParam = null;
            Object currStringId = -1;
            String currValue = "";
            while (resultSet.next()) {
                int colIndex = 1;
                Object jselectId = resultSet.getObject(colIndex++);
                String param = resultSet.getString(colIndex++);
                String stringId = resultSet.getString(colIndex++);
                String anyKey = resultSet.getString(colIndex++);
                String anyValue = resultSet.getString(colIndex++);
                if (!(currJselectId == null || jselectId.equals(currJselectId) && param.equals(currParam))) {
                    int varIndex = 1;
                    insertStatement.setObject(varIndex++, currJselectId);
                    insertStatement.setObject(varIndex++, currParam);
                    insertStatement.setObject(varIndex++, currStringId);
                    insertStatement.setObject(varIndex++, currValue);
                    insertStatement.setObject(varIndex++, intValue);
                    insertStatement.addBatch();
                    currValue = "";
                }
                currJselectId = jselectId;
                currParam = param;
                if (stringId == null) {
                    currStringId = -1;
                    continue;
                }
                if (stringId.equals(currStringId)) {
                    currValue = currValue + " " + anyKey + "=" + anyValue;
                    continue;
                }
                currStringId = stringId;
                currValue = " " + anyKey + "=" + anyValue;
            }
            if (currJselectId != null) {
                int varIndex = 1;
                insertStatement.setObject(varIndex++, currJselectId);
                insertStatement.setObject(varIndex++, currParam);
                insertStatement.setObject(varIndex++, currStringId);
                insertStatement.setObject(varIndex++, currValue);
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " ctrlCfgJslPrepare "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " ctrlCfgJslPrepare end ");
    }

    private void ctrlCfgJslPrepare3() throws Exception {
        Date start = new Date();
        String selectStatementString = "select EVENT_NEW_TMP.JSELECT_ID, OBJECT_NEW_TMP.JOB_ID, OBJCOMP_NEW_TMP.COMPONENT_NAME,       OBJCOMP_NEW_TMP.COMPONENT_ATTR from OBJCOMP_NEW_TMP, EVENT_NEW_TMP, OBJECT_NEW_TMP where EVENT_NEW_TMP.OBJECT_ID=OBJCOMP_NEW_TMP.OBJECT_ID and OBJECT_NEW_TMP.OBJECT_ID=EVENT_NEW_TMP.OBJECT_ID order by EVENT_NEW_TMP.JSELECT_ID, OBJECT_NEW_TMP.JOB_ID, COMPONENT_NO";
        String insertStatementString = "insert into tmp_jselectComp (JSELECT_ID, JOB_ID, ARCH_COMP_NAMES, KEEP_COMP_NAMES) values (?,?,?,?)";
        PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
        PreparedStatement selectStatement = this.prepareStatement(selectStatementString);
        ResultSet resultSet = selectStatement.executeQuery();
        ArrayList<String> archCompNamesList = new ArrayList<String>();
        ArrayList<String> keepCompNamesList = new ArrayList<String>();
        BigDecimal lastJselectId = null;
        BigDecimal lastJobId = null;
        if (resultSet.next()) {
            do {
                int colIndex = 1;
                BigDecimal jselectId = resultSet.getBigDecimal(colIndex++);
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                String componentName = resultSet.getString(colIndex++);
                BigDecimal componentAttr = resultSet.getBigDecimal(colIndex++);
                if (lastJselectId == null) {
                    lastJselectId = jselectId;
                    lastJobId = jobId;
                } else if (!lastJselectId.equals(jselectId) || !lastJobId.equals(jobId)) {
                    String archCompNames = this.list2String(archCompNamesList);
                    String keepCompNames = this.list2String(keepCompNamesList);
                    int varIndex = 1;
                    insertStatement.setBigDecimal(varIndex++, lastJselectId);
                    insertStatement.setBigDecimal(varIndex++, lastJobId);
                    insertStatement.setString(varIndex++, archCompNames);
                    insertStatement.setString(varIndex++, keepCompNames);
                    insertStatement.addBatch();
                    lastJselectId = jselectId;
                    lastJobId = jobId;
                    archCompNamesList.clear();
                    keepCompNamesList.clear();
                }
                if ((componentAttr.intValue() & 4) != 0) {
                    archCompNamesList.add(componentName);
                }
                if ((componentAttr.intValue() & 8) == 0) continue;
                keepCompNamesList.add(componentName);
            } while (resultSet.next());
            String archCompNames = this.list2String(archCompNamesList);
            String keepCompNames = this.list2String(keepCompNamesList);
            int varIndex = 1;
            insertStatement.setBigDecimal(varIndex++, lastJselectId);
            insertStatement.setBigDecimal(varIndex++, lastJobId);
            insertStatement.setString(varIndex++, archCompNames);
            insertStatement.setString(varIndex++, keepCompNames);
            insertStatement.addBatch();
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
        }
        selectStatement.close();
        insertStatement.close();
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " ctrlCfgJslPrepare3 "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " ctrlCfgJslPrepare3 end ");
    }

    private String list2String(List<String> archCompNamesList) {
        StringBuffer result = new StringBuffer();
        for (String e : archCompNamesList) {
            String v = "\"" + e + "\"";
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(v);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ctrlCfgJslPrepareAccountingOn() throws Exception {
        Date start = new Date();
        String selectStatementString = "select JSELECT_ID, ACC_ATTRBITS from CFG_JSELECT_NEW_TMP";
        String insertStatementString = "insert into tmp_jselectAttr (JSELECT_ID, param, STRING_ID, value, intValue) values (?,?,?,?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            String param = "ACCOUNTING_ON";
            Integer stringId = -1;
            String value = "";
            while (resultSet.next()) {
                BigDecimal accAttrbits;
                int colIndex = 1;
                Object jselectId = resultSet.getObject(colIndex++);
                Integer accountingOn = ((accAttrbits = resultSet.getBigDecimal(colIndex++)).intValue() & 0x10) == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
                int varIndex = 1;
                insertStatement.setObject(varIndex++, jselectId);
                insertStatement.setObject(varIndex++, param);
                insertStatement.setObject(varIndex++, stringId);
                insertStatement.setObject(varIndex++, value);
                insertStatement.setObject(varIndex++, accountingOn);
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " jobsdclAsciiPrepare2 "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " jobsdclAsciiPrepare2 end ");
    }

    private void initATOJCfg() throws Exception {
        Date start = new Date();
        TextEdiboss parEdiboss = new TextEdiboss();
        TextCfgRc cfgRc = new TextCfgRc(parEdiboss.getRccFile());
        this.cfgRcToDb(cfgRc);
        this.slavesToDb();
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " initATOJCfg "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " initATOJCfg end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCtrlCfgJsRcReactionData() throws SQLException {
        Date start = new Date();
        String selectStatementString = "select JOB_ID, JOB_NAME, SEQUENCE_NO, FUNCTION_CLASS_NAME from tmp_ctrl_cfgjsrcreaction_base";
        String insertStatementString = "insert into ctrl_cfgjsrcreaction (jsid, step, nr, rcname, action) values (?,?,?,?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            block5: while (resultSet.next()) {
                String functionClassName;
                Integer count;
                Hashtable<String, Integer> functionCount = new Hashtable<String, Integer>();
                int colIndex = 1;
                BigDecimal jobId = resultSet.getBigDecimal(colIndex++);
                String jobName = resultSet.getString(colIndex++);
                Integer sequenceNo = resultSet.getInt(colIndex++);
                if ((count = (Integer)functionCount.get(functionClassName = resultSet.getString(colIndex++))) == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                functionCount.put(functionClassName, count);
                CfgJobEntry cfgJobEntry = this.getCfgJob().get(jobName);
                if (cfgJobEntry == null) {
                    LOG.warn((Object)("Attention: Missing job configuration for job " + jobName + " (JobId=" + jobId + ")! - Check manually."));
                    for (int nrIndex = 0; nrIndex < FALL_BACK_RC_REACTION.length; ++nrIndex) {
                        String rcname = FALL_BACK_RC_REACTION[nrIndex][0];
                        String action = FALL_BACK_RC_REACTION[nrIndex][1];
                        int varIndex = 1;
                        insertStatement.setObject(varIndex++, jobId);
                        insertStatement.setObject(varIndex++, sequenceNo);
                        insertStatement.setObject(varIndex++, nrIndex + 1);
                        insertStatement.setObject(varIndex++, rcname);
                        insertStatement.setObject(varIndex++, action);
                        insertStatement.addBatch();
                    }
                    continue;
                }
                List<CfgJobStep> jobSteps = cfgJobEntry.getSteps();
                for (int stepIndex = 0; stepIndex < jobSteps.size(); ++stepIndex) {
                    int cfgFunctionCount = 0;
                    CfgJobStep jobStep = jobSteps.get(stepIndex);
                    try {
                        String jobstepName = jobStep.getName(0);
                        if (!jobstepName.equalsIgnoreCase(functionClassName) || ++cfgFunctionCount != count) continue;
                        Hashtable rcClassHash = jobStep.getRcClass();
                        List cfgRcEntryList = jobStep.getRclist();
                        for (int nrIndex = 0; nrIndex < cfgRcEntryList.size(); ++nrIndex) {
                            CfgRcEntry cfgRcEntry = (CfgRcEntry)cfgRcEntryList.get(nrIndex);
                            CfgJobStepRcReaction rcReaction = (CfgJobStepRcReaction)rcClassHash.get(cfgRcEntry);
                            String rcname = cfgRcEntry.getName();
                            String action = rcReaction.getName();
                            int varIndex = 1;
                            insertStatement.setObject(varIndex++, jobId);
                            insertStatement.setObject(varIndex++, sequenceNo);
                            insertStatement.setObject(varIndex++, nrIndex + 1);
                            insertStatement.setObject(varIndex++, rcname);
                            insertStatement.setObject(varIndex++, action);
                            insertStatement.addBatch();
                        }
                        continue block5;
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn((Object)("Attention: Missing job step configuration for job " + jobName + " (JobId=" + jobId + ")! - Check manually."));
                        LOG.debug((Object)("Attention: Missing job step configuration for job " + jobName + " (JobId=" + jobId + ")! - Check manually."), (Throwable)e);
                    }
                }
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " readCtrlCfgJsRcReactionData "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " readCtrlCfgJsRcReactionData end ");
    }

    private void cfgRcToDb(TextCfgRc cfgRc) throws SQLException {
        Date start = new Date();
        String insertStatementString = "insert into tmp_rcclass (name, rneg, rfrom, rto) values (?,?,?,?)";
        PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
        List<CfgRcEntry> entries = cfgRc.getEntries();
        for (CfgRcEntry entry : entries) {
            String name = entry.getName();
            List values = entry.getValues();
            for (CfgRcValue value : values) {
                int isNeg = value.isNeg() ? 1 : 0;
                int from = value.getFrom();
                int to = value.getTo();
                int varIndex = 1;
                insertStatement.setObject(varIndex++, name);
                insertStatement.setObject(varIndex++, isNeg);
                insertStatement.setObject(varIndex++, from);
                insertStatement.setObject(varIndex++, to);
                insertStatement.addBatch();
            }
        }
        insertStatement.executeBatch();
        if (!this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
        insertStatement.close();
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + " cfgRcToDb "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + " cfgRcToDb end ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jselectAsciiPrepare() throws Exception {
        Date start = new Date();
        String selectStatementString = "select CFG_JSELECT_NEW_TMP.JSELECT_ID, ATTRSTRINGS_NEW_TMP.ANYVALUE from CFG_JSELECT_NEW_TMP, ATTRSTRINGS_NEW_TMP where CFG_JSELECT_NEW_TMP.EVT_PATTERN_ID=ATTRSTRINGS_NEW_TMP.STRING_ID and       (CFG_JSELECT_NEW_TMP.SIGNIF_NO_OF_ATTR=0 or ATTRSTRINGS_NEW_TMP.PART<=CFG_JSELECT_NEW_TMP.SIGNIF_NO_OF_ATTR) order by CFG_JSELECT_NEW_TMP.JSELECT_ID, ATTRSTRINGS_NEW_TMP.PART";
        String insertStatementString = "insert into tmp_jselectAscii (Jselect_ID, Evt_pattern) values (?,?)";
        try (Statement selectStatement = this.createStatement();){
            PreparedStatement insertStatement = this.prepareStatement(insertStatementString);
            ResultSet resultSet = selectStatement.executeQuery(selectStatementString);
            Object lastJselectId = null;
            StringBuffer evtPattern = new StringBuffer();
            while (resultSet.next()) {
                int colIndex = 1;
                Object jselectId = resultSet.getObject(colIndex++);
                String attrElement = resultSet.getString(colIndex++);
                if (jselectId.equals(lastJselectId)) {
                    evtPattern.append(" ");
                    evtPattern.append(attrElement);
                    continue;
                }
                if (lastJselectId != null) {
                    int varIndex = 1;
                    insertStatement.setObject(varIndex++, lastJselectId);
                    insertStatement.setObject(varIndex++, evtPattern.toString());
                    insertStatement.addBatch();
                }
                evtPattern = new StringBuffer();
                evtPattern.append(attrElement);
                lastJselectId = jselectId;
            }
            if (lastJselectId != null) {
                int varIndex = 1;
                insertStatement.setObject(varIndex++, lastJselectId);
                insertStatement.setObject(varIndex++, evtPattern.toString());
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            insertStatement.close();
        }
        Date end = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(ConverterA2J.durationString(start, end) + "jselectAsciiToDb "));
        }
        this.userInfo(ConverterA2J.durationString(start, end) + "jselectAsciiToDb end ");
    }
}

