/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.IRowsetReader;
import de.axway.aim.controller.master.convert.IntegerColumnDescription;
import de.axway.aim.controller.master.convert.JdbcRowset;
import de.axway.aim.controller.master.convert.TableDescription;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;

public class JdbcRowsetReader
implements IRowsetReader {
    private final TableDescription tableDescription;
    private Object[] rowDataHash;
    private ResultSet r;
    private JdbcRowset rowset;

    public JdbcRowsetReader(String version, TableDescription fieldTableDescription, String tableName, Connection connection, String postfix, String orderList) throws SQLException {
        this.tableDescription = fieldTableDescription;
        connection.setAutoCommit(false);
        String tName = fieldTableDescription.getName().toUpperCase().replaceAll("\\.", "_");
        if (postfix != null) {
            tName = tName + postfix;
        }
        String colIdentifiers = "";
        List<IColumnDescription> columnDescriptions = fieldTableDescription.getColumnDescriptions();
        for (int i = 0; i < columnDescriptions.size(); ++i) {
            if (i != 0) {
                colIdentifiers = colIdentifiers + ", ";
            }
            colIdentifiers = colIdentifiers + columnDescriptions.get(i).getName();
        }
        String queryStatement = "select " + colIdentifiers + " from " + tName;
        if (orderList != null) {
            queryStatement = queryStatement + " order by " + orderList;
        }
        Statement stmt = connection.createStatement();
        this.r = stmt.executeQuery(queryStatement);
        this.rowset = new JdbcRowset(version, fieldTableDescription);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public Object[] getRowData() {
        return this.rowDataHash;
    }

    @Override
    public IRowset getRowSet() {
        return this.rowset;
    }

    @Override
    public boolean next() throws Exception {
        List<IColumnDescription> columnDescriptions = this.tableDescription.getColumnDescriptions();
        if (this.r.next()) {
            int index = 1;
            Iterator<IColumnDescription> iterator2 = columnDescriptions.iterator();
            this.rowDataHash = new Object[columnDescriptions.size()];
            int i = 0;
            while (iterator2.hasNext()) {
                Object value;
                IColumnDescription columnDescription = iterator2.next();
                if (columnDescription instanceof IntegerColumnDescription) {
                    if ((value = this.r.getObject(index++)) == null) {
                        value = 0;
                    }
                } else if ((value = this.r.getString(index++)) == null) {
                    value = "";
                }
                this.rowDataHash[i++] = value;
            }
            return true;
        }
        this.rowDataHash = null;
        return false;
    }
}

