/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.IRowsetReader;
import de.axway.aim.controller.master.convert.ISchemahandler;
import de.axway.aim.controller.master.convert.JdbcRowsetReader;
import de.axway.aim.controller.master.convert.SchemaDataReader;
import de.axway.aim.controller.master.convert.SchemaDescription;
import de.axway.aim.controller.master.convert.TableDescription;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;

public class JdbcSchemaDataReader
extends SchemaDataReader {
    private final Connection fieldConnection;
    private String fieldPostfix = null;
    private Map<String, String> orderHashtable = new Hashtable<String, String>();
    private final String version;

    public JdbcSchemaDataReader(SchemaDescription schemaDescription, ISchemahandler schemaRowhandler, Connection connection) {
        super(schemaDescription, schemaRowhandler);
        this.fieldConnection = connection;
        this.version = schemaDescription.getVersion();
    }

    @Override
    protected IRowsetReader getRowSetReader(TableDescription tableDescription, String tableName) throws Exception {
        String orderList = this.orderHashtable.get(tableName);
        return new JdbcRowsetReader(this.version, tableDescription, tableName, this.fieldConnection, this.fieldPostfix, orderList);
    }

    public void setPostfix(String postfix) {
        this.fieldPostfix = postfix;
    }

    public void addOrder(String tableName, String orderList) {
        this.orderHashtable.put(tableName, orderList);
    }
}

