/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.CmpFc;
import de.axway.aim.controller.master.convert.Converter;
import de.axway.aim.controller.master.convert.ConverterA2J;
import java.util.ArrayList;
import java.util.Arrays;

public class Main {
    private static final String COMMAND_EXPORT = "export";
    private static final String COMMAND_IMPORT = "import";
    private static final Object COMMAND_DATABASE = "database";
    private static final Object DBCOMMAND_REMOVE = "remove";
    private static final Object DBCOMMAND_CREATE = "create";

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(args));
        if (list.size() == 0) {
            Main.printUsage();
            return;
        }
        try {
            Integer maxBatchCount = -1;
            Integer maxFetchSize = 1000;
            String option = "";
            while (list.size() > 0) {
                option = list.remove(0);
                if (option.equals("mb") && list.size() > 0) {
                    option = list.remove(0);
                    maxBatchCount = Integer.valueOf(option);
                    continue;
                }
                if (option.equals("mf") && list.size() > 0) {
                    option = list.remove(0);
                    maxFetchSize = Integer.valueOf(option);
                    continue;
                }
                if (option.equals("convert") && list.size() == 1) {
                    String direction = list.remove(0);
                    if (direction.equals("ascii2jdbc")) {
                        ConverterA2J converter = new ConverterA2J(maxBatchCount, maxFetchSize);
                        converter.convertcAsciiToJJdbc();
                    } else {
                        Main.printUsage();
                    }
                    return;
                }
                if (option.equals(COMMAND_DATABASE) && list.size() == 1) {
                    String dbCommand = list.remove(0);
                    if (dbCommand.equals(DBCOMMAND_REMOVE)) {
                        Converter converter = new Converter(maxBatchCount, maxFetchSize);
                        converter.dbRemove();
                    } else if (dbCommand.equals(DBCOMMAND_CREATE)) {
                        Converter converter = new Converter(maxBatchCount, maxFetchSize);
                        converter.dbCreate();
                    } else {
                        Main.printUsage();
                    }
                    return;
                }
                if (option.equals(COMMAND_IMPORT) && list.size() == 1) {
                    String db = list.remove(0);
                    if (db.equals("jascii")) {
                        Converter converter = new Converter(maxBatchCount, maxFetchSize);
                        converter.jAsciiDbImport();
                    } else {
                        Main.printUsage();
                    }
                    return;
                }
                if (option.equals(COMMAND_EXPORT) && list.size() == 1) {
                    String db = list.remove(0);
                    if (db.equals("jascii")) {
                        Converter converter = new Converter(maxBatchCount, maxFetchSize);
                        converter.jAsciiDbExport();
                    } else {
                        Main.printUsage();
                    }
                    return;
                }
                if (!option.equals("cmpfc")) continue;
                CmpFc.cmpFc();
                return;
            }
            Main.printUsage();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: <options> <command>");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("-mb <mb>: max. batch command execution. -1 for unlimited");
        System.out.println("");
        System.out.println("Commands:");
        System.out.println("  convert ascii2jdbc: cascii to jjdbc");
        System.out.println("  import jascii: Import javamaster database from ascii files.");
        System.out.println("  export jascii: Export javamaster database to ascii files.");
    }
}

