/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.HexColumnDescription;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.IRowsetReader;
import de.axway.aim.controller.master.convert.SimpleRowset;
import de.axway.aim.controller.master.convert.TableDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Rowset
implements IRowsetReader {
    private static final Pattern ID_PATTERN = Pattern.compile("\\s*ID\\s*=(.*)");
    protected static final Log LOG = LogFactory.getLog((String)"de.axway.Controller");
    protected BufferedReader br;
    protected int lineNr = 0;
    private List<IColumnDescription> columnDescriptions = null;
    protected SimpleRowset rs;
    protected Object[] rowDataHash;
    protected boolean isHeader;

    public Rowset(TableDescription tableDescription, File dirAsciiData) throws IOException {
        File file = new File(dirAsciiData, tableDescription.getName());
        this.br = new BufferedReader(new FileReader(file));
        this.isHeader = true;
        this.readHeader(tableDescription);
    }

    private void readHeader(TableDescription tableDescription) throws IOException {
        this.rs = new SimpleRowset(tableDescription);
        this.columnDescriptions = this.rs.tableDescription.getColumnDescriptions();
        this.rs.setExpectedEntries(-1);
        Pattern patternVersion = Pattern.compile("VERSION=(.*)");
        Pattern patternExpectedEntries = Pattern.compile("# Expected Entries=(.*)");
        Pattern patternCreationDate = Pattern.compile("# \\*\\*\\*\\*\\* Creation date: (.*) \\*\\*\\*\\*\\*");
        Pattern patternSource = Pattern.compile("# \\*\\*\\*\\*\\* Source: (.*)");
        String line = null;
        while ((line = this.readLine()) != null) {
            Matcher versionMatcher = patternVersion.matcher(line);
            Matcher matcherExpectedEntries = patternExpectedEntries.matcher(line);
            Matcher matcherSource = patternSource.matcher(line);
            Matcher matcherCreationDate = patternCreationDate.matcher(line);
            if (matcherExpectedEntries.matches()) {
                this.rs.setExpectedEntries(Integer.parseInt(matcherExpectedEntries.group(1)));
                continue;
            }
            if (versionMatcher.matches()) {
                this.rs.setVersion(versionMatcher.group(1));
                break;
            }
            if (matcherSource.matches()) {
                this.rs.source = matcherSource.group(1);
                continue;
            }
            if (!matcherCreationDate.matches()) continue;
            this.rs.creationDate = matcherCreationDate.group(1);
        }
    }

    @Override
    public Object[] getRowData() {
        return this.rowDataHash;
    }

    @Override
    public boolean next() throws Exception {
        if (this.rs.getExpectedEntries() <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No entries expected.");
            }
            return false;
        }
        String line = null;
        while ((line = this.readLine()) != null) {
            if (line.matches("^\\s*(#.*)?$")) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Ignore line " + this.lineNr + " (empty or comment): " + line));
                continue;
            }
            Matcher idMatcher = ID_PATTERN.matcher(line);
            if (idMatcher.matches()) {
                this.isHeader = false;
                String id = idMatcher.group(1).trim().replaceFirst("^\"(.*)\"", "$1");
                this.rowDataHash = new Object[this.columnDescriptions.size()];
                this.rowDataHash[0] = id;
                return this.readIDInfo();
            }
            if (this.isHeader) continue;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error at line " + this.lineNr + ": " + line));
            }
            throw new Exception("Parse error at line " + this.lineNr + ":" + line);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"End of file reached.");
        }
        return false;
    }

    private boolean readIDInfo() throws IOException, Exception {
        Iterator<IColumnDescription> columnIterator = this.columnDescriptions.iterator();
        IColumnDescription columnDescription = columnIterator.next();
        int i = 1;
        while (columnIterator.hasNext()) {
            columnDescription = columnIterator.next();
            this.rowDataHash[i++] = this.readColumnValue(columnDescription);
        }
        return true;
    }

    private Object readColumnValue(IColumnDescription columnDescription) throws IOException, Exception {
        Object value;
        String line = this.readLine();
        String valueString = line.trim().replaceFirst("^\"(.*)\"", "$1");
        if (columnDescription instanceof HexColumnDescription) {
            value = Integer.valueOf(valueString, 16);
        } else {
            if (valueString.startsWith("\"") && !valueString.endsWith("\"")) {
                valueString = valueString.substring(1);
                if (line.endsWith(" ")) {
                    valueString = valueString.concat(" ");
                }
                do {
                    Matcher idMatcher2;
                    if ((idMatcher2 = ID_PATTERN.matcher(line = this.readLine())).matches()) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)("error at line " + this.lineNr + ": " + line));
                        }
                        throw new Exception("parse error at line " + this.lineNr + ":" + line);
                    }
                    if (line == null) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)("error at line " + this.lineNr + ": " + line + "; End of file reached."));
                        }
                        throw new Exception("parse error at line " + this.lineNr + ":" + line + "; End of file reached.");
                    }
                    valueString = valueString.concat("\n" + line);
                } while (!line.endsWith("\""));
                valueString = valueString.substring(0, valueString.length() - 1);
            }
            value = valueString;
        }
        return value;
    }

    protected String readLine() throws IOException {
        String line = this.br.readLine();
        if (line != null) {
            ++this.lineNr;
        }
        return line;
    }

    @Override
    public void close() throws Exception {
        this.br.close();
    }

    @Override
    public IRowset getRowSet() {
        return this.rs;
    }
}

