/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.CharColumnDescription;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IntegerColumnDescription;
import de.axway.aim.controller.master.convert.SchemaDescription;
import de.axway.aim.controller.master.convert.StringColumnDescription;
import de.axway.aim.controller.master.convert.TableDescription;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlHandler {
    private SchemaDescription schemaDescription = new SchemaDescription();
    private TableDescription tableDescription;

    public void close() {
    }

    public SchemaDescription getTableDescriptions() {
        return this.schemaDescription;
    }

    public void createTableBegin(String createTableBegin) {
        String tableName = createTableBegin.replaceFirst("(?i).*create\\s+table\\s+(\\S+)\\s*\\(", "$1");
        this.tableDescription = new TableDescription(tableName);
        this.schemaDescription.addTableDescription(this.tableDescription);
    }

    public void createTableAddColumn(String fieldName, String fieldType) {
        String columnName = fieldName.trim();
        String columnType = fieldType.replaceFirst("\\s*,?\\s*$", "");
        Pattern pattern = Pattern.compile("([^()]+)(\\(.*\\))?");
        Matcher matcher = pattern.matcher(columnType);
        if (matcher.matches()) {
            IColumnDescription columnDescription;
            String type = matcher.group(1);
            if ("integer".equalsIgnoreCase(type) || "number".equalsIgnoreCase(type)) {
                columnDescription = new IntegerColumnDescription(columnName);
            } else if ("varchar".equalsIgnoreCase(type) || "varchar2".equalsIgnoreCase(type)) {
                StringColumnDescription stringColumnDescription = new StringColumnDescription(columnName);
                String rangeString = matcher.group(2).replaceFirst("\\((.*)\\)", "$1");
                int range = Integer.parseInt(rangeString);
                stringColumnDescription.setMaxlength(range);
                columnDescription = stringColumnDescription;
            } else if ("char".equalsIgnoreCase(type)) {
                CharColumnDescription charColumnDescription = new CharColumnDescription(columnName);
                String rangeString = matcher.group(2).replaceFirst("\\((.*)\\)", "$1");
                Integer range = Integer.valueOf(rangeString);
                charColumnDescription.setRange(range);
                columnDescription = charColumnDescription;
            } else {
                System.out.println("parse fails: " + fieldType);
                return;
            }
            this.tableDescription.addColumnDecription(columnDescription);
        } else {
            System.out.println("parse fails: " + fieldType);
        }
    }

    public void createTableEnd(String createTableEnd) {
        this.tableDescription = null;
    }
}

