/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.BaseAsciiWriter;
import de.axway.aim.controller.master.convert.ConvertException;
import de.axway.aim.controller.master.convert.HexColumnDescription;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IRowset;
import de.axway.aim.controller.master.convert.StringColumnDescription;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;

public class StandardAsciiSchemaRowWriteHandler
extends BaseAsciiWriter {
    private static final int HEX_RADIX = 16;
    private List<IColumnDescription> columnDescriptions;
    private File dataDir;

    public StandardAsciiSchemaRowWriteHandler() throws IOException {
        String actisedi = System.getProperty("ACTISEDI");
        this.dataDir = new File(actisedi + "/spool/asciidata/");
    }

    @Override
    public void close() {
    }

    @Override
    public void handleTableStart(IRowset rowSet) throws ConvertException {
        if (!(rowSet.equals(this.rowSet) || rowSet.getTableDescription().getName().equals("attrstrings.new") || rowSet.getTableDescription().getName().equals("strings.new"))) {
            this.rowSet = rowSet;
            this.columnDescriptions = rowSet.getTableDescription().getColumnDescriptions();
            this.rowIndex = 0;
            String name = rowSet.getTableDescription().getName();
            this.file = new File(this.dataDir, name);
            this.fileTmp = new File(this.dataDir, name + ".tmp");
            try {
                this.pw = new PrintWriter(new FileWriter(this.fileTmp));
            }
            catch (IOException e) {
                throw new ConvertException(e);
            }
            String version = rowSet.getVersion();
            this.pw.println();
            this.pw.println("# ***** Creation date: " + rowSet.getCreationDate() + " *****");
            this.pw.println("# ***** Source: " + rowSet.getSource());
            this.pw.println("#");
            Iterator<IColumnDescription> columnDescriptionIterator = this.columnDescriptions.iterator();
            IColumnDescription columnDescription = columnDescriptionIterator.next();
            String paramId = columnDescription.getName();
            int parIndex = 0;
            this.pw.println(String.format("# %2s. ID=%s", ++parIndex, paramId));
            while (columnDescriptionIterator.hasNext()) {
                columnDescription = columnDescriptionIterator.next();
                paramId = columnDescription.getName();
                this.pw.println(String.format("# %2s. \t%s", ++parIndex, paramId));
            }
            this.pw.println("#");
            this.pw.println("# Expected Entries=");
            this.pw.println("                                                                ");
            this.pw.println("VERSION=" + version);
            this.pw.println();
            this.pw.println();
        }
    }

    @Override
    protected void writeEntry() {
    }

    @Override
    public void handleTableRow(Object[] rowDataHash) {
        if (this.rowSet != null) {
            ++this.rowIndex;
            Iterator<IColumnDescription> columnDescriptionIterator = this.columnDescriptions.iterator();
            IColumnDescription columnDescription = columnDescriptionIterator.next();
            int pIndex = 0;
            Object value = rowDataHash[pIndex++];
            this.pw.println("ID=" + value);
            while (columnDescriptionIterator.hasNext()) {
                columnDescription = columnDescriptionIterator.next();
                value = rowDataHash[pIndex++];
                if (columnDescription instanceof StringColumnDescription) {
                    value = "\"" + value + "\"";
                } else if (columnDescription instanceof HexColumnDescription) {
                    Integer intValue = value instanceof String ? Integer.valueOf((String)value) : (Integer)value;
                    value = Integer.toString(intValue, 16);
                }
                this.pw.println("\t" + value);
            }
            this.pw.println();
        }
    }
}

