/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.Rowset;
import de.axway.aim.controller.master.convert.TableDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringsRowset
extends Rowset {
    private static final Pattern ID_PATTERN = Pattern.compile("\\s*ID\\s*=\\s*(\\S+)\\s*");
    private static final Pattern R_NAME_VALUE_PATTERN = Pattern.compile("([^(]*)=(.*)");
    private List<Object[]> rowDataBuffer = new ArrayList<Object[]>();
    private TableDescription fieldTableDescription;

    public StringsRowset(TableDescription tableDescription, File dataDir) throws Exception {
        super(tableDescription, dataDir);
        this.fieldTableDescription = tableDescription;
    }

    @Override
    public boolean next() throws Exception {
        if (this.rowDataBuffer.size() > 0) {
            this.rowDataHash = this.rowDataBuffer.remove(0);
            return true;
        }
        int lineNr = 0;
        String line = this.br.readLine();
        while (line != null) {
            Matcher idMatcher = ID_PATTERN.matcher(line);
            if (idMatcher.matches()) {
                this.isHeader = false;
                if (this.rs.getExpectedEntries() > 0) {
                    String stringIdValue = idMatcher.group(1).trim().replaceFirst("^\"(.*)\"", "$1");
                    line = this.br.readLine();
                    int noS = Integer.parseInt(line.trim());
                    int pairIndex = 0;
                    int index = 0;
                    while (pairIndex < noS) {
                        String value;
                        String name;
                        ++pairIndex;
                        Object[] rowDataHash = new Object[this.fieldTableDescription.getColumnDescriptions().size()];
                        int i = 0;
                        rowDataHash[i++] = stringIdValue;
                        rowDataHash[i++] = ++index;
                        line = this.br.readLine();
                        String left = line.trim();
                        line = this.br.readLine();
                        String right = line.trim();
                        String jType = "";
                        if (left.equals("l")) {
                            Matcher rNameValueMatcher = R_NAME_VALUE_PATTERN.matcher(right);
                            if (rNameValueMatcher.matches()) {
                                name = rNameValueMatcher.group(1).substring(1);
                                value = rNameValueMatcher.group(2);
                                jType = "EA";
                            } else {
                                name = null;
                                value = right.substring(1);
                            }
                        } else {
                            name = left.substring(1);
                            value = right.substring(1);
                        }
                        rowDataHash[i++] = name;
                        rowDataHash[i++] = value;
                        rowDataHash[i++] = jType;
                        this.rowDataBuffer.add(rowDataHash);
                    }
                    int size = this.rowDataBuffer.size();
                    if (size == 0) {
                        return false;
                    }
                    this.rowDataHash = this.rowDataBuffer.remove(0);
                    return true;
                }
            } else if (!this.isHeader) {
                if (line.matches("^\\s*(#.*)?$")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ignore line " + lineNr + ": " + line));
                    }
                } else {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("error at line " + lineNr + ": " + line));
                    }
                    throw new Exception("parse error");
                }
            }
            line = this.br.readLine();
            ++lineNr;
        }
        return false;
    }
}

