/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.convert;

import de.axway.aim.controller.master.convert.CharColumnDescription;
import de.axway.aim.controller.master.convert.HexColumnDescription;
import de.axway.aim.controller.master.convert.IColumnDescription;
import de.axway.aim.controller.master.convert.IntegerColumnDescription;
import de.axway.aim.controller.master.convert.StringColumnDescription;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlList;

public class TableDescription {
    private String aName;
    private String aGlobalId;
    private List<String> index = new ArrayList<String>();
    private List<IColumnDescription> columnDescriptions = new ArrayList<IColumnDescription>();

    @XmlList
    public List<String> getIndex() {
        return this.index;
    }

    public void setIndex(List<String> paramIndex) {
        this.index = paramIndex;
    }

    public TableDescription() {
    }

    public TableDescription(String tableName) {
        this.setName(tableName);
    }

    public void addColumnDecription(IColumnDescription columnDescription) {
        this.columnDescriptions.add(columnDescription);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("table: " + this.getName() + "\n");
        sb.append("==================================\n");
        for (IColumnDescription type : this.columnDescriptions) {
            String rangeString;
            Integer range;
            if (type instanceof StringColumnDescription) {
                StringColumnDescription stringColumnDescription = (StringColumnDescription)type;
                sb.append("  " + type.getName() + ":string\n");
                range = stringColumnDescription.getMaxlength();
                rangeString = range == null ? "<unlimited>" : range.toString();
                sb.append("    range:" + rangeString + "\n");
                continue;
            }
            if (type instanceof CharColumnDescription) {
                CharColumnDescription charColumnDescription = (CharColumnDescription)type;
                sb.append("  " + type.getName() + ":char\n");
                range = charColumnDescription.getRange();
                rangeString = range == null ? "<unlimited>" : range.toString();
                sb.append("    range:" + rangeString + "\n");
                continue;
            }
            if (type instanceof IntegerColumnDescription) {
                sb.append("  " + type.getName() + ":integer\n");
                continue;
            }
            sb.append("  " + type.getName() + ":unknown\n");
        }
        return sb.toString();
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.aName;
    }

    @XmlElements(value={@XmlElement(name="strCol", type=StringColumnDescription.class), @XmlElement(name="intCol", type=IntegerColumnDescription.class), @XmlElement(name="hexCol", type=HexColumnDescription.class), @XmlElement(name="charCol", type=CharColumnDescription.class)})
    public List<IColumnDescription> getColumnDescriptions() {
        return this.columnDescriptions;
    }

    public final void setName(String paramName) {
        this.aName = paramName;
    }

    public void setGlobalId(String globalId) {
        this.aGlobalId = globalId;
    }

    @XmlAttribute(name="globalId")
    public String getGlobalId() {
        return this.aGlobalId;
    }
}

