/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.log;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.lib.FunctionCall;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.lib.Slave;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.IReferenceTime;
import de.axway.aim.controller.master.log.LogbookError;
import de.axway.lib.license.LicenseEntry;
import de.axway.lib.util.ActisFile;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Logbook
implements ILogbook,
IReferenceTime {
    private static final String ARCHIVE_PREFIX = "lg";
    private static final String[] LOP_ERROR_TABLE = new String[]{"OK", "CONNECT FAILED", "SEND FAILED", "RECEIVE FAILED", "SHUTDOWN FAILED", "WRONG LISTEN SOCKET MODE", "CREATE LISTEN SOCKET FAILED", "CLOSE FAILED", "FILE SEND FAILED", "FILE RECEIVE FAILED", "CONNECT TIMEOUT", "SEND TIMEOUT", "RECEIVE TIMEOUT", "VERSION INCOMPATIBLE", "CLIENT NOT AVAILABLE", "NO MEMORY", "POS CONFIRM FAILED", "NEG CONFIRM FAILED", "CONFIRM_RECEIVE FAILED"};
    private static final String[] LOP_ANSWER_TABLE = new String[]{"OK", "NOT OK", "NO JSL ENTRY", "TIMEOUT", "NO SUCH STEP", "NO SUCH FILE", "NO PERMISSION", "NO SUCH PROGRAM", "NO EXECUTE PERMISSION", "CANT FORK", "CANT REDIRECT", "CANT RECEIVE OEP", "OEP NOT COMPLETE", "CFCFG NO INSTALL SHELL", "CFCFG RECEIVE FAILED", "CFCFG INSTALL FAILED", "POP IS READONLY", "EI OPEN FAILED", "CFCFG INSTALL TIMEOUT", "AUTO UPDATE ON", "AUTO UPDATE OFF", "SEARCH FAILED", "USER PROFILE DEFINED", "DATA ALREADY TRANSFERED", "RESULT IN REP", "NO SUCH CLIENT", "OBJECT EXCHANGE FAILED"};
    private static final Log LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.log.Logbook");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    private static final DateFormat DATE_FORMAT_SHORT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final boolean DEFAULT_MICROSEC = true;
    private static String lineSeparator = System.getProperty("line.separator");
    private static final String RECORD_TYPE_START = "Start*******";
    private static final String RECORD_TYPE_STOP = "Stop********";
    private static final String RECORD_TYPE_START_RECFG = "Start Recfg*";
    private static final String RECORD_TYPE_END_RECFG = "End Recfg***";
    private static final String RECORD_TYPE_START_APPL = "Start Appl**";
    private static final String RECORD_TYPE_END_APPL = "End Appl****";
    private static final String RECORD_TYPE_EVENT_START = "Event Start*";
    private static final String RECORD_TYPE_EVENT_END = "Event End***";
    private static final String RECORD_TYPE_EVENT_ERROR = "Event Error*";
    private static final String RECORD_TYPE_CREATE_JOB = "Create Job**";
    private static final String RECORD_TYPE_END_JOB = "End Job*****";
    private static final String RECORD_TYPE_REMOVE_JOB = "Remove Job**";
    private static final String RECORD_TYPE_EXECUTE_JS = "Execute JS**";
    private static final String RECORD_TYPE_BUSY_JS = "Busy JS*****";
    private static final String RECORD_TYPE_SUSPEND_JOB = "Suspend Job*";
    private static final String RECORD_TYPE_DESUSP_JOB = "DeSusp Job**";
    private static final String RECORD_TYPE_RETRYFULL_JS = "Retryfull JS";
    private static final String RECORD_TYPE_STOP_JOB = "Stop Job****";
    private static final String RECORD_TYPE_RESULT = "Result******";
    private static final String RECORD_TYPE_CREATE_BIC = "Create BIC**";
    private static final String RECORD_TYPE_COMMAND = "Command*****";
    private static final String RECORD_TYPE_COMMAND_END = "Command End*";
    private static final String RECORD_TYPE_OBJECT = "Object******";
    private static final String RECORD_TYPE_ERROR = "Error*******";
    private static final String RECORD_TYPE_ERROR_DBI = "Error DBI***";
    private static final String RECORD_TYPE_WARNING = "Warning*****";
    private static final String RECORD_TYPE_INFO = "Info********";
    private static final String RECORD_TYPE_LICENSE = "License*****";
    private static final String RECORD_TYPE_SYSTEM_CALL = "System Call*";
    private static final String RECORD_TYPE_ONRETRYFULL = "OnRetryFull*";
    private static final String RECORD_TYPE_ONERROR = "OnError*****";
    private static final String RECORD_TYPE_ONMAXEXETIME = "OnMaxExeTime";
    private static IReferenceTime referenceTime;
    private static ILogbook logbook;
    private static Formatter logbFormatter;
    private static File logbFile;
    private static boolean isMicrosec;
    private String processId;
    private String systemUser;
    private static String jdbcInfo;
    private static String logfileDir;

    private Logbook() {
        referenceTime = this;
        this.systemUser = System.getProperty("user.name");
        this.processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    private static void setJdbcConnection(Connection jdbcCon) {
        try {
            DatabaseMetaData databaseMetaData = jdbcCon.getMetaData();
            String productVersion = databaseMetaData.getDatabaseProductVersion();
            String driverVersion = databaseMetaData.getDriverVersion();
            String jdbcDriver = databaseMetaData.getDriverName();
            String jdbcUrl = databaseMetaData.getURL();
            jdbcInfo = productVersion + ";" + driverVersion + ";" + jdbcDriver + ";" + jdbcUrl;
        }
        catch (SQLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Can not get jdbc meta data.", (Throwable)e);
            }
            jdbcInfo = "<no jdbc meta data>";
        }
    }

    private static void open(File newLogbFile) throws IOException {
        if (newLogbFile.equals(logbFile)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Logbook already configured this port.");
            }
        } else {
            if (logbFormatter != null) {
                logbFormatter.close();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("logfile changed form " + logbFile.getAbsolutePath() + " to " + newLogbFile.getAbsolutePath()));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("new logb file: " + newLogbFile));
            }
            logbFile = newLogbFile;
            logbFormatter = new Formatter(new FileWriter(newLogbFile, true));
        }
    }

    public void setSystemUser(String systemUser) {
        this.systemUser = systemUser;
    }

    public static ILogbook getLogbook() throws LogbookError {
        if (logbook == null) {
            throw new LogbookError("Logbook not configured.");
        }
        return logbook;
    }

    public static void configure(Connection jdbcCon, int port) throws LogbookError {
        String logfile = new ActisFile("spool/runtime/logb.").toString();
        Logbook.configure(logfile, jdbcCon, port);
    }

    public static void configure(String logfile, Connection jdbcCon, int port) throws LogbookError {
        int idx = Math.max(logfile.lastIndexOf(47), logfile.lastIndexOf(92));
        logfileDir = idx == -1 ? "." : logfile.substring(0, idx);
        File newLogbFile = new File(logfile + port);
        if (logbook == null) {
            logbook = new Logbook();
        }
        try {
            Logbook.open(newLogbFile);
        }
        catch (IOException e) {
            throw new LogbookError("Logbook open error: " + newLogbFile, e);
        }
        Logbook.setJdbcConnection(jdbcCon);
    }

    public static void close() {
        logbook = null;
        if (logbFormatter != null) {
            logbFormatter.close();
        }
        logbFormatter = null;
    }

    private String getDateTimeString() {
        Date date = referenceTime.getDateTime();
        if (isMicrosec) {
            return DATE_FORMAT.format(date);
        }
        return DATE_FORMAT_SHORT.format(date);
    }

    @Override
    public Date getDateTime() {
        return new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String revision) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|MyPID=%-10.10s|%-16.16s|Revision: %-6.6s|%-16s|%s";
        String recordId = RECORD_TYPE_START;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, this.getProcessId(), this.getUser(), revision, jdbcInfo, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String revision, String signal) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|MyPID=%-10.10s|%-16.16s|Revision: %-6.6s|%-16s|Signal=%-5.5s|%s";
        String recordId = RECORD_TYPE_STOP;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, this.getProcessId(), this.getUser(), revision, jdbcInfo, signal, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRecfg(String initiatorFunction, long applicationId, String userSignalId, String functionInitiator, String slave) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.16s|%10.10s|%-16.16s|%-16.16s|%-17.128s|%s";
        String recordId = RECORD_TYPE_START_RECFG;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, initiatorFunction, applicationId, userSignalId, functionInitiator, slave, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endRecfg(String initiatorFunction, long applicationId, String userSignalId, String functionInitiator, String slave, String returnCode) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.16s|%10.10s|%-16.16s|%-16.16s|%-17.128s|%6.6s|%s";
        String recordId = RECORD_TYPE_END_RECFG;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, initiatorFunction, applicationId, userSignalId, functionInitiator, slave, returnCode, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAppl(String applicationType, long applicationId, String user, String host, String profile) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.16s|%10.10s|%-16.16s|%-16.128s|Profile=%s|%s";
        String recordId = RECORD_TYPE_START_APPL;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, applicationType, applicationId, user, host, profile, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endAppl(String applicationType, long applicationId, String reason) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.16s|%10.10s|%-16.16s|%s";
        String recordId = RECORD_TYPE_END_APPL;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, applicationType, applicationId, reason, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventStartEnd(boolean isStart, Event event, String host, String cfID) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.128s|%10.10s|%10.10s|%c%4.4s 0x%02x%s|%-32.32s|%-16.16s|%s|%s%s%s";
        String dateTimeString = this.getDateTimeString();
        long jobId = 0L;
        long eventId = 0L;
        int eventType = 0;
        char eventTypeName = '?';
        String eventAttibutes = "";
        String eventParameters = "";
        String initiator = "";
        String syncMsg = "";
        String emergMsg = "";
        String jsl = "";
        if (event != null) {
            Job job;
            eventId = event.getId();
            if (!isStart && (job = event.getJob()) != null) {
                jobId = job.getId();
            }
            eventType = event.getType();
            initiator = event.getInitiator();
            if ((eventType & 2) != 0) {
                eventTypeName = 'T';
            } else if ((eventType & 4) != 0) {
                eventTypeName = 'U';
            } else if ((eventType & 1) != 0) {
                eventTypeName = 'S';
            }
            if ((eventType & 0x80) != 0) {
                syncMsg = "sync";
            }
            if ((eventType & 0x40) != 0) {
                emergMsg = " E";
            }
            if (isStart) {
                eventAttibutes = event.getAttr(-1);
                eventParameters = event.getParamString();
            } else {
                jsl = "JSL: line#=" + event.getJslLine();
            }
        }
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, isStart ? RECORD_TYPE_EVENT_START : RECORD_TYPE_EVENT_END, dateTimeString, host, jobId, eventId, Character.valueOf(eventTypeName), syncMsg, eventType, emergMsg, initiator, cfID, isStart ? eventAttibutes : jsl, isStart ? eventParameters : "", isStart ? "|" : "", lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    @Override
    public void eventStart(Event event, String host, String cfID) {
        this.eventStartEnd(true, event, host, cfID);
    }

    @Override
    public void eventEnd(Event event, String host, String cfID) {
        this.eventStartEnd(false, event, host, cfID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventError(String action, long jobId, long eventId, String errorDescription, String slave, String senderPidVersion) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.16s|%10.10s|%10.10s|%s|%s|%s|%s";
        String recordId = RECORD_TYPE_EVENT_ERROR;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, action, jobId, eventId, errorDescription, slave, senderPidVersion, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createJob(String jobName, long jobId, long eventId, long businessObjectId) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%10.10s|%10.10s|%s";
        String recordId = RECORD_TYPE_CREATE_JOB;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, eventId, businessObjectId, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endJob(String jobName, long jobId, long eventId, long businessObjectId, int lastReturnCode) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%10.10s|%10.10s|%6.6s|%s";
        String recordId = RECORD_TYPE_END_JOB;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, eventId, businessObjectId, lastReturnCode, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(String jobName, long jobId, long eventId, long businessObjectId, int lastReturnCode) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%10.10s|%10.10s|%6.6s|%s";
        String recordId = RECORD_TYPE_REMOVE_JOB;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, eventId, businessObjectId, lastReturnCode, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeJS(FunctionCall fc, Slave slave) {
        String group;
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%-32.32s|%-24.24s|%-16.128s|%s|%s|%-16.128s|%s";
        String recordId = RECORD_TYPE_EXECUTE_JS;
        String dateTimeString = this.getDateTimeString();
        CtrlJobStep js = (CtrlJobStep)fc.getJobStep();
        int maxExecTime = js.getMaxExecTime();
        String maxRunTimeS = "Max. run time: " + (maxExecTime > 0 ? "" + maxExecTime + " sec" : "no limit");
        if (js.isGrouped()) {
            String groupName;
            try {
                groupName = js.getGroupName();
            }
            catch (Exception e) {
                LOG.error((Object)"getGroupName", (Throwable)e);
                groupName = "***invalid***";
            }
            group = "Group: Slave/Name/Max=" + slave.getName() + '/' + groupName + "/" + js.getMaxGroupCalls();
        } else {
            group = "No Group: Slave/Name/Max=" + slave.getName() + "//";
        }
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, fc.getJobName(), fc.getJobId(), fc.getStepName(), fc.getInstanceName4Log(), slave.getHostname(), fc.getReal(), maxRunTimeS, group, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void busyJS(String jobName, long jobId, String workflowStepName, String functionCallId, String host, String functionCall) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%-32.32s|%-24.24s|%-16.128s|%s|%s";
        String recordId = RECORD_TYPE_BUSY_JS;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, workflowStepName, functionCallId, host, functionCall, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    public static String getStrDate(long date) {
        if (date == 0L || date == Long.MAX_VALUE) {
            return "";
        }
        return DATE_FORMAT_SHORT.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspendJob(String jobName, long jobId, String workflowStepName, String workflowStepId, long suspendTime, Attributes<String> activateAttr) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%-32.32s|%-24.24s|TIME_UNTIL=%s|ACTIVATE_ATTR=%s|%s";
        String recordId = RECORD_TYPE_SUSPEND_JOB;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, workflowStepName, workflowStepId, Logbook.getStrDate(suspendTime), activateAttr != null ? activateAttr.get(-1, ' ') : "", lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deSuspJob(String jobName, long jobId, String workflowStepName, int workflowStepId, int stepRetry, String workflowSelection) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%32.32s|%-24.24s|%s|%s";
        String recordId = RECORD_TYPE_DESUSP_JOB;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, workflowStepName, "" + jobId + '.' + workflowStepId + '.' + stepRetry, workflowSelection, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retryfullJS(String jobName, long jobId, String workflowStepName, String functionCallId, String host, String functionCall) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%-32.32s|%-24.24s|%-16.128s|%s|%s";
        String recordId = RECORD_TYPE_RETRYFULL_JS;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, workflowStepName, functionCallId, host, functionCall, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopJob(Job job) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%-32.32s|%-24.24s|%s";
        String recordId = RECORD_TYPE_STOP_JOB;
        String dateTimeString = this.getDateTimeString();
        String stepId = "" + job.getId() + '.' + job.getActiveStep() + ".";
        stepId = job.getCurrentStep() != null ? stepId + job.getCurrentStep().getRetry() : stepId + "?";
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, job.getName(), job.getId(), job.getCurrentStep() == null ? "<invalid>" : job.getCurrentStep().getName(), stepId, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void result(String jobName, long jobId, String workflowStepName, String functionCallId, String host, String returnCode, String protocolFile) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%-32.32s|%-24.24s|%-16.128s|%s|%s|%s";
        String recordId = RECORD_TYPE_RESULT;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, jobId, workflowStepName, functionCallId, host, returnCode, protocolFile != null && protocolFile.length() > 0 ? protocolFile.replace("\\", "/") : "No logfile", lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createBIC(String buildinCommand, long jobId, long eventId, long businessObjectId) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.32s|%10.10s|%10.10s|%10.10s|%s";
        String recordId = RECORD_TYPE_CREATE_BIC;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, buildinCommand, jobId, eventId, businessObjectId, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandStartEnd(String label, String initiator, long commandId, String user, String host, String commandDesignation, String[] argv) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.16s|% 10d|%-16.16s|%-16.128s|%-16.16s|%s%s";
        String dateTimeString = this.getDateTimeString();
        StringBuffer buf = new StringBuffer();
        if (argv != null) {
            for (String val : argv) {
                if (val != null) {
                    buf.append(val);
                } else {
                    buf.append("");
                }
                buf.append("|");
            }
        }
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, label, dateTimeString, initiator, new Long(commandId), user, host, commandDesignation, buf.toString(), lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    @Override
    public void command(String startInitiator, long commandId, String user, String host, String commandDesignation, String[] argv) {
        this.commandStartEnd(RECORD_TYPE_COMMAND, startInitiator, commandId, user, host, commandDesignation, argv);
    }

    @Override
    public void commandEnd(String startInitiator, long commandId, String user, String host, String commandDesignation, String[] result) {
        this.commandStartEnd(RECORD_TYPE_COMMAND_END, startInitiator, commandId, user, host, commandDesignation, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void object(String host, long jobId, long objectId, String referenceId, List<String> componentNameList) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.128s|%10.10s|%10.10s|%s%s|%s";
        String recordId = RECORD_TYPE_OBJECT;
        String dateTimeString = this.getDateTimeString();
        StringBuffer callParameterStringBuffer = new StringBuffer();
        for (String callParameter : componentNameList) {
            callParameterStringBuffer.append("|");
            callParameterStringBuffer.append(callParameter);
        }
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, host, jobId, objectId, referenceId, callParameterStringBuffer.toString(), lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    private String getUser() {
        return this.systemUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void witter(String witterClass, String message) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|MyPID=%-10.10s|%s|%s";
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, witterClass, dateTimeString, this.getProcessId(), message, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    @Override
    public void error(String message) {
        this.witter(RECORD_TYPE_ERROR, message);
    }

    @Override
    public void errorDBI(String message) {
        this.witter(RECORD_TYPE_ERROR_DBI, message);
    }

    @Override
    public void warning(String message) {
        this.witter(RECORD_TYPE_WARNING, message);
    }

    @Override
    public void info(String message) {
        this.witter(RECORD_TYPE_INFO, message);
    }

    private String answerName(int code) {
        if (code < 0 || code > LOP_ANSWER_TABLE.length) {
            return LOP_ANSWER_TABLE[1];
        }
        return LOP_ANSWER_TABLE[code];
    }

    private String lopRcName(int code) {
        if (code < 0) {
            code = -code;
        }
        if (code < 0 || code > LOP_ERROR_TABLE.length) {
            return LOP_ERROR_TABLE[1];
        }
        return LOP_ERROR_TABLE[code];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void answLog(String witterClass, String protType, boolean from, Slave slave, int retCode, long id, String idStrOrMsg) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|Answer %9s|%10s|ANSWER=%d  %s|\"%s\" protocol %s \"Slave=%s\" \"Port=%d\" \"Host=%s\"|%s%s";
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, witterClass, dateTimeString, protType, id == 0L ? "" : String.valueOf(id), retCode, this.answerName(retCode), protType, from ? "from" : "to", slave.getName(), slave.getPort(), slave.getHostname(), idStrOrMsg, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    @Override
    public void answInfo(String protType, boolean from, Slave slave, int retCode, long id, String idStrOrMsg) {
        this.answLog(RECORD_TYPE_INFO, protType, from, slave, retCode, id, idStrOrMsg);
    }

    @Override
    public void answWarning(String protType, boolean from, Slave slave, int retCode, long id, String idStrOrMsg) {
        this.answLog(RECORD_TYPE_WARNING, protType, from, slave, retCode, id, idStrOrMsg);
    }

    @Override
    public void answError(String protType, boolean from, Slave slave, int retCode, long id, String idStrOrMsg) {
        this.answLog(RECORD_TYPE_ERROR, protType, from, slave, retCode, id, idStrOrMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendLog(String protType, Slave slave, int retCode, long id, String idStrOrMsg) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|Send   %9s|%10s|LOP_RC=%d  %s|\"%s\" protocol to \"Slave=%s\" \"Port=%d\" \"Host=%s\"|%s%s";
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, retCode == 0 ? RECORD_TYPE_INFO : RECORD_TYPE_ERROR, dateTimeString, protType, id == 0L ? "" : String.valueOf(id), retCode, retCode == 0 ? "SENT OK" : this.lopRcName(retCode), protType, slave.getName(), slave.getPort(), slave.getHostname(), idStrOrMsg, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void license(List<LicenseEntry> licenseEntryList) {
        for (LicenseEntry licenseEntry : licenseEntryList) {
            String componentName = licenseEntry.getComponent();
            String logicalCustomerName = licenseEntry.getLogClient();
            String customerNameFull = licenseEntry.getClientName();
            String host = licenseEntry.getHostname();
            int portNumber = licenseEntry.getPortId();
            String partnerRelationCount = licenseEntry.getTxtUseNo();
            String operatingSystem = licenseEntry.getOsName();
            String operatingSystemVersion = licenseEntry.getOsVersion();
            String tsimVersion = licenseEntry.getEdiVersion();
            String licenseNumber = licenseEntry.getLicenseNo();
            String licenseType = licenseEntry.getLicenseType();
            int licenseValidUntil = licenseEntry.getExpiry();
            String format = "%-12.12s|%-10.10s|%-19.19s|%-79.79s|%-12.12s|%-8.8s|%-8.8s|%-8.8s|%-10.10s|%-8.8s|%-9.9s|%-10.10s|%s|%s";
            String recordId = RECORD_TYPE_LICENSE;
            String licenseValidUntilString = "" + licenseValidUntil;
            Logbook logbook = this;
            synchronized (logbook) {
                logbFormatter.format(format, recordId, componentName, logicalCustomerName, customerNameFull, host, portNumber, partnerRelationCount, operatingSystem, operatingSystemVersion, tsimVersion, licenseNumber, licenseType, licenseValidUntilString, lineSeparator);
                logbFormatter.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemCall(String buildinWorkflowName, long jobId, String workflowStepName, int rc, long duration, String functionCall) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-16.32s|%10.10s|%s|System call executed: RC=%d errno=0 duration=%d sec|%s|%s";
        String recordId = RECORD_TYPE_SYSTEM_CALL;
        String dateTimeString = this.getDateTimeString();
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, buildinWorkflowName, jobId, workflowStepName, rc, duration, functionCall, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onExceptionCmd(String recordId, String jobName, String jsName, String fcInstance, int rc, String functionCall, long[] fuck) {
        long start = System.currentTimeMillis();
        String format = "%-12.12s|%-19.23s|%-32.32s|%10.10s|%s%s%s|System call executed: RC=%d errno=0 duration=%d sec|%s|%s";
        String dateTimeString = this.getDateTimeString();
        String abstand = jsName != null && jsName.length() > 0 && fcInstance != null && fcInstance.length() > 0 ? "   " : "";
        Logbook logbook = this;
        synchronized (logbook) {
            logbFormatter.format(format, recordId, dateTimeString, jobName, fuck[0], jsName, abstand, fcInstance, rc, fuck[1], functionCall, lineSeparator);
            logbFormatter.flush();
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    @Override
    public void onRetryFull(String jobName, long jobId, String jsName, String fcInstance, int rc, long duration, String functionCall) {
        this.onExceptionCmd(RECORD_TYPE_ONRETRYFULL, jobName, jsName, fcInstance, rc, functionCall, new long[]{jobId, duration});
    }

    @Override
    public void onError(String jobName, long jobId, String jsName, String fcInstance, int rc, long duration, String functionCall) {
        this.onExceptionCmd(RECORD_TYPE_ONERROR, jobName, jsName, fcInstance, rc, functionCall, new long[]{jobId, duration});
    }

    @Override
    public void onMaxExeTime(String jobName, long jobId, String jsName, String fcInstance, int rc, long duration, String functionCall) {
        this.onExceptionCmd(RECORD_TYPE_ONMAXEXETIME, jobName, jsName, fcInstance, rc, functionCall, new long[]{jobId, duration});
    }

    public static void setReferenceTime(IReferenceTime referenceTime) {
        Logbook.referenceTime = referenceTime;
    }

    public static void setLineSeparator(String lineSeparator) {
        Logbook.lineSeparator = lineSeparator;
    }

    public static void setMicrosec(boolean isMicrosec) {
        Logbook.isMicrosec = isMicrosec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void archive() throws IOException {
        long start = System.currentTimeMillis();
        if (logbFile == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Archive logbook impossible - no logfile configured.");
            }
        } else {
            int nr;
            String archiveBaseName;
            block11: {
                File logDir = new File(logfileDir);
                SimpleDateFormat archiveSdf = new SimpleDateFormat("yyMMdd");
                archiveBaseName = ARCHIVE_PREFIX + archiveSdf.format(referenceTime.getDateTime()) + ".";
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Archive base name: " + archiveBaseName));
                }
                ArchiveFilenameFilter filter = new ArchiveFilenameFilter(archiveBaseName);
                Object[] files = logDir.listFiles(filter);
                Arrays.sort(files);
                if (files.length > 0) {
                    Object last = files[files.length - 1];
                    Pattern pattern = Pattern.compile("lg\\d{6}\\.(\\d{3})");
                    Matcher matcher = pattern.matcher(((File)last).getName());
                    if (matcher.matches()) {
                        nr = Integer.parseInt(matcher.group(1)) + 1;
                        break block11;
                    } else {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"Unexpected state.");
                        }
                        return;
                    }
                }
                nr = 1;
            }
            DecimalFormat df = new DecimalFormat("000");
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Archive name defined: " + logfileDir + "/" + archiveBaseName + df.format(nr)));
            }
            File archiveFile = new File(logfileDir + "/" + archiveBaseName + df.format(nr));
            ILogbook iLogbook = logbook;
            synchronized (iLogbook) {
                logbFormatter.close();
                logbFile.renameTo(archiveFile);
                logbFormatter = new Formatter(new FileWriter(logbFile));
            }
        }
        WorkerThread.addLogTime(System.currentTimeMillis() - start);
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public static void setLogbook(ILogbook logbook) {
        Logbook.logbook = logbook;
    }

    static {
        logbFormatter = null;
        logbFile = null;
        isMicrosec = true;
    }

    private static class ArchiveFilenameFilter
    implements FilenameFilter {
        private final String archiveBaseName;

        public ArchiveFilenameFilter(String archiveBaseName) {
            this.archiveBaseName = archiveBaseName;
        }

        @Override
        public boolean accept(File dir, String name) {
            Pattern pattern = Pattern.compile(this.archiveBaseName + "\\d{3}");
            Matcher matcher = pattern.matcher(name);
            return matcher.matches();
        }
    }
}

