/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.queue.FcSingleGroup;
import de.axway.aim.controller.master.queue.JobQueue;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FcGroupQueue
implements JobQueue {
    private Log log = LogFactory.getLog((String)"master.queue.FcGroup");
    private CtrlDispAppl dispatcher;
    private JobQueue runQueue;
    private boolean started = false;
    private Hashtable<String, FcSingleGroup> groups = new Hashtable();

    public FcGroupQueue(JobQueue runQueue, CtrlDispAppl dispatcher) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("created: " + runQueue));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"created:");
        }
        this.runQueue = runQueue;
        this.dispatcher = dispatcher;
    }

    public void addActive(IJob job) {
        this.runJob(job, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"start: ");
        }
        Hashtable<String, FcSingleGroup> hashtable = this.groups;
        synchronized (hashtable) {
            this.started = true;
            Enumeration<FcSingleGroup> t = this.groups.elements();
            while (t.hasMoreElements()) {
                FcSingleGroup gt = t.nextElement();
                try {
                    gt.start();
                }
                catch (Exception e) {
                    this.log.error((Object)("can not start GroupThread " + gt.getName()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Hashtable<String, FcSingleGroup> hashtable = this.groups;
        synchronized (hashtable) {
            this.started = false;
            Enumeration<FcSingleGroup> t = this.groups.elements();
            while (t.hasMoreElements()) {
                FcSingleGroup gt = t.nextElement();
                try {
                    gt.shutdown();
                }
                catch (Exception e) {
                    this.log.error((Object)("can not stop GroupThread " + gt.getName()), (Throwable)e);
                }
            }
            this.groups.clear();
        }
    }

    @Override
    public String getStatus() {
        return this.getStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus(boolean verbose) {
        StringBuffer buf = new StringBuffer();
        buf.append("Groups: ");
        buf.append(this.groups.size());
        Hashtable<String, FcSingleGroup> hashtable = this.groups;
        synchronized (hashtable) {
            Enumeration<FcSingleGroup> e = this.groups.elements();
            while (e.hasMoreElements()) {
                buf.append("\n    ");
                FcSingleGroup gt = e.nextElement();
                buf.append(String.format("Name: %s, started: %s, run: %d, max: %d, wait: %d", gt.getName(), this.started, gt.sizeRun(), gt.getMax(), gt.sizeWait()));
                if (gt.sizeRun() <= 0 || !verbose) continue;
                buf.append(gt.getStatus("    "));
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWaitingJob(IJob job) {
        String groupName;
        IJobStep js = (IJobStep)job.getCurrentStep();
        if (js == null) {
            CtrlDispAppl.getLogGrouping().error((Object)("js is null for " + job.getId()));
            return false;
        }
        try {
            groupName = js.getGroupName();
            CtrlDispAppl.getLogGrouping().debug((Object)("RemoveWaitingJob jobId=" + job.getId() + " jsName=" + js.getName() + " groupName=" + groupName));
        }
        catch (Exception e) {
            CtrlDispAppl.getLogGrouping().error((Object)("Getting group name failed." + e));
            return false;
        }
        if (groupName == null || groupName.length() == 0) {
            return false;
        }
        Hashtable<String, FcSingleGroup> hashtable = this.groups;
        synchronized (hashtable) {
            CtrlDispAppl.getLogGrouping().debug((Object)("Will remove job=" + job.getId() + " from waitingJobs"));
            FcSingleGroup g = this.groups.get(groupName);
            if (g != null) {
                return g.removeWaiting(job);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingJob(IJob job) {
        String groupName;
        IJobStep js = (IJobStep)job.getCurrentStep();
        if (js == null) {
            CtrlDispAppl.getLogGrouping().error((Object)("js is null for job=" + job.getId()));
            return;
        }
        CtrlDispAppl.getLogGrouping().debug((Object)("Start addWaitingJob for job=" + job.getId() + " jsName=" + js.getName()));
        try {
            groupName = js.getGroupName();
        }
        catch (Exception e) {
            CtrlDispAppl.getLogGrouping().error((Object)("Error getting groupName." + e));
            return;
        }
        if (groupName == null || groupName.length() == 0) {
            CtrlDispAppl.getLogGrouping().warn((Object)("groupName does not exist for jobId=" + job.getId() + " jsName=" + js.getName()));
            return;
        }
        Hashtable<String, FcSingleGroup> hashtable = this.groups;
        synchronized (hashtable) {
            FcSingleGroup g = this.groups.get(groupName);
            if (g != null) {
                g.addWaiting(job);
            }
        }
    }

    @Override
    public void runJob(IExecutable executable) {
        this.runJob(executable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob(IExecutable executable, boolean run) {
        FcSingleGroup q;
        String groupName;
        if (!executable.isGrouped()) {
            if (run) {
                this.runQueue.runJob(executable);
            }
            return;
        }
        IJob job = (IJob)executable;
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("ID: " + job.getId()));
        }
        int activeStepNo = 0;
        try {
            groupName = job instanceof CtrlJob ? ((activeStepNo = ((CtrlJob)job).getActiveStepNo()) >= 1 ? ((IJobStep)job.getStep(activeStepNo)).getGroupName() : ((IJobStep)job.getCurrentStep()).getGroupName()) : ((IJobStep)job.getCurrentStep()).getGroupName();
        }
        catch (Exception e) {
            this.dispatcher.stopJob(job, e);
            return;
        }
        if (groupName == null || groupName.length() == 0) {
            if (run) {
                this.runQueue.runJob(job);
            }
            return;
        }
        IJobStep js = activeStepNo >= 1 ? (IJobStep)job.getStep(activeStepNo) : (IJobStep)job.getCurrentStep();
        int max = js.getMaxGroupCalls();
        Hashtable<String, FcSingleGroup> hashtable = this.groups;
        synchronized (hashtable) {
            q = this.groups.get(groupName);
            if (q == null) {
                q = new FcSingleGroup(groupName, max, this.runQueue);
                if (this.started) {
                    try {
                        q.start();
                    }
                    catch (Exception e) {
                        this.log.error((Object)("cannot start GroupThread " + groupName), (Throwable)e);
                    }
                }
                this.groups.put(groupName, q);
                CtrlDispAppl.getLogGrouping().debug((Object)("Added groupName=" + groupName + " to groupList because of jobId=" + job.getId() + " jsName=" + js.getName()));
            }
        }
        js.setFcGroup(q);
        if (run) {
            q.add(js);
        } else {
            q.addActive(js);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJs(IJobStep js) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("step: " + (Object)((Object)js)));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("ID: " + js.getJobId() + "." + js.getStepNo()));
        }
        FcSingleGroup gt = js.getFcGroup();
        if (gt != null) {
            js.setFcGroup(null);
            if (!gt.remove((IJob)js.getJob())) {
                this.log.warn((Object)("can not remove job " + js.getJobId() + "." + js.getName() + " from group " + gt.getName()));
            }
            Hashtable<String, FcSingleGroup> hashtable = this.groups;
            synchronized (hashtable) {
                if (gt.sizeRun() == 0 && gt.sizeWait() == 0) {
                    this.groups.remove(gt.getName());
                    CtrlDispAppl.getLogGrouping().debug((Object)("Remove group=" + gt.getName() + " from groupsList for jobId=" + js.getJobId()));
                }
            }
        }
    }

    public Log getLog() {
        return this.log;
    }
}

