/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.queue.IWait;
import de.axway.aim.controller.master.queue.MaxExecTimeJob;
import de.axway.aim.controller.master.queue.WaitQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FcKillQueue
extends WaitQueue {
    private Log log = LogFactory.getLog((String)"master.queue.FcKill");
    private CtrlDispAppl dispatcher;

    public FcKillQueue(CtrlDispAppl dispatcher) {
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)"created");
        }
        this.setName("FcKillQueue");
        this.dispatcher = dispatcher;
        this.start();
    }

    public void watchJob(IJob job, int maxExecTime) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("job: " + job + ", maxExecTime: " + maxExecTime));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("ID: " + job.getId() + ", maxExecTime: " + maxExecTime));
        }
        super.newWaitJob(new MaxExecTimeJob(job, maxExecTime));
    }

    @Override
    protected boolean exec(IWait job) {
        if (this.getLog().isTraceEnabled()) {
            this.log.trace((Object)("job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)("ID: " + job.getId()));
        }
        this.dispatcher.killBusyFc(((MaxExecTimeJob)job).getJob(), ((MaxExecTimeJob)job).getWaitDate(), ((MaxExecTimeJob)job).getMaxExecTime());
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((Object)"return true");
        }
        return true;
    }

    @Override
    public Log getLog() {
        return this.log;
    }
}

