/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.queue.JobQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FcSingleGroup {
    private Log log = LogFactory.getLog((String)"master.queue.FcGroup");
    private TreeSet<IJob> waitingJobs = new TreeSet();
    private Set<IJob> runningJobs = new HashSet<IJob>();
    private JobQueue runQueue;
    private String name;
    private int max;
    private boolean down = true;

    public FcSingleGroup(String groupName, int max, JobQueue runQueue) {
        this.runQueue = runQueue;
        this.max = max;
        this.name = groupName;
    }

    public String getStatus() {
        return this.getStatus("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus(String indent) {
        StringBuffer buf = new StringBuffer();
        buf.append("\n");
        buf.append(indent);
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            buf.append("Running steps:");
            buf.append(String.format("\n%s%10.10s | %32.32s | %32.32s", indent, "Job Id", "Job name", "Step name"));
            buf.append(String.format("\n%s%10.10s-+-%32.32s-+-%32.32s", indent, "------------------------", "------------------------", "------------------------"));
            for (IJob job : this.runningJobs) {
                buf.append(String.format("\n%s%10s | %32s | %32s", indent, job.getId(), job.getName(), job.getCurrentStepName()));
            }
            buf.append("\n");
            buf.append(indent);
            buf.append("Waiting steps:");
            buf.append(String.format("\n%s%10.10s | %32.32s | %32.32s | %4.4s", indent, "Job Id", "Job name", "Step name", "Prio"));
            buf.append(String.format("\n%s%10.10s-+-%32.32s-+-%32.32s-+-%4.4s", indent, "------------------------", "------------------------", "------------------------", "------------------------"));
            for (IJob job : this.waitingJobs) {
                buf.append(String.format("\n%s%10s | %32s | %32s | %4d", indent, job.getId(), job.getName(), job.getCurrentStepName(), job.getPrio()));
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public void start() {
        this.down = false;
        while (this.doRun()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.down = true;
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            this.waitingJobs.clear();
            this.runningJobs.clear();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMax() {
        return this.max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeRun() {
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            return this.runningJobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeWait() {
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            return this.waitingJobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActive(IJobStep step) {
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            this.runningJobs.add((IJob)step.getJob());
            CtrlDispAppl.getLogGrouping().debug((Object)("Added jobId=" + step.getJobId() + " stepName=" + step.getName() + " to runningJobs."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IJobStep step) {
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            int max = step.getMaxGroupCalls();
            if (max < this.max) {
                this.max = max;
            }
            CtrlDispAppl.getLogGrouping().debug((Object)"Listing content of runningJobs.");
            for (IJob job : this.runningJobs) {
                CtrlDispAppl.getLogGrouping().debug((Object)("runningJobs contains jobId=" + job.getId() + " jobName=" + job.getName() + " stepName=" + job.getCurrentStepName()));
            }
            if (!this.runningJobs.contains((IJob)step.getJob())) {
                this.waitingJobs.add((IJob)step.getJob());
                CtrlDispAppl.getLogGrouping().debug((Object)("Added jobId=" + step.getJobId() + " stepName=" + step.getName() + " to waitingJobs."));
            }
        }
        this.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IJob job) {
        boolean old;
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            if (this.runningJobs.contains(job)) {
                old = this.runningJobs.remove(job);
                this.waitingJobs.remove(job);
                CtrlDispAppl.getLogGrouping().debug((Object)("Removed from runningJobs and waitingJobs, job=" + job.getId() + " stepName=" + job.getCurrentStepName()));
            } else {
                CtrlDispAppl.getLogGrouping().debug((Object)("Removed from waitingJobs (does not exist in runningJobs), job=" + job.getId() + " stepName=" + job.getCurrentStepName()));
                old = this.waitingJobs.remove(job);
            }
        }
        this.doRun();
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeWaiting(IJob job) {
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            CtrlDispAppl.getLogGrouping().debug((Object)("Removing jobID=" + job.getId() + " stepName=" + job.getCurrentStepName() + " from waitingJobs"));
            return this.waitingJobs.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaiting(IJob job) {
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            if (!this.runningJobs.contains(job)) {
                this.waitingJobs.add(job);
                CtrlDispAppl.getLogGrouping().debug((Object)("Added to waitingJobs jobId=" + job.getId() + " stepName=" + job.getCurrentStepName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRun() {
        Set<IJob> set = this.runningJobs;
        synchronized (set) {
            IJob job;
            if (this.down) {
                return false;
            }
            if (this.runningJobs.size() < this.max && (job = this.waitingJobs.pollFirst()) != null) {
                this.runningJobs.add(job);
                this.runQueue.runJob(job);
                CtrlDispAppl.getLogGrouping().debug((Object)("Added job=" + job.getId() + " to runningJobs and runQueue. stepName=" + job.getCurrentStepName()));
                return true;
            }
        }
        return false;
    }
}

