/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.queue.JobQueue;
import de.axway.aim.controller.master.queue.SortedJobId;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;

class JobSeq {
    private Log log;
    private JobQueue queue;
    private SortedSet<SortedJobId> jobs = new TreeSet<SortedJobId>();
    private String name;
    private Set<IJob> running = new HashSet<IJob>();
    private Object runningSync = new Object();
    private boolean run = false;

    public JobSeq(Log log, JobQueue queue, String seqName, boolean started) {
        this.log = log;
        this.run = started;
        this.queue = queue;
        this.name = seqName;
    }

    public boolean isRunning() {
        return this.run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.runningSync;
        synchronized (object) {
            this.run = true;
            this.startNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.runningSync;
        synchronized (object) {
            this.run = false;
            this.running.clear();
            this.jobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IJob job, boolean doRun, boolean isRun) {
        Object object = this.runningSync;
        synchronized (object) {
            if (!this.run || !doRun || isRun) {
                this.jobs.add(new SortedJobId(job, !doRun));
                if (isRun) {
                    this.running.add(job);
                }
            } else if (this.running.contains(job)) {
                this.queue.runJob(job);
            } else {
                this.jobs.add(new SortedJobId(job, !doRun));
                this.startNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IJob job) {
        boolean ret;
        Object object = this.runningSync;
        synchronized (object) {
            ret = this.jobs.remove(new SortedJobId(job, false));
            this.running.remove(job);
            this.startNext();
        }
        return ret;
    }

    private void startNext() {
        Iterator<IJob> e;
        if (!this.run || this.jobs.size() == 0) {
            return;
        }
        SortedJobId sj = this.jobs.first();
        if (this.running.contains(sj.getJob())) {
            return;
        }
        if (this.running.size() > 0 && (e = this.running.iterator()).hasNext()) {
            IJob runningJob = e.next();
            if (runningJob.getId() < sj.getJob().getId()) {
                return;
            }
            this.running.remove(runningJob);
            this.startNext();
            return;
        }
        this.running.add(sj.getJob());
        if (!sj.isInactive()) {
            this.queue.runJob(sj.getJob());
        } else {
            this.log.warn((Object)("next job " + sj.getJob().getId() + " is inactive"));
        }
    }

    public IJob getRunning() {
        try {
            return this.jobs.first().getJob();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.jobs.size();
    }

    public String getStatus(String indent, boolean verbose) {
        StringBuffer buf = new StringBuffer();
        Iterator sJobs = null;
        Iterator<IJob> rJobs = null;
        IJob job2 = null;
        if (this.jobs.size() > 0 && verbose) {
            buf.append("\n");
            buf.append(indent);
            buf.append("waiting jobs: ");
            buf.append(this.jobs.size());
            buf.append("\n");
            buf.append(String.format("%s%10s | %32s\n", indent, "Job Id", "Job name"));
            buf.append(String.format("%s%10.10s-+-%32.32s\n", indent, "----------------", "----------------"));
            sJobs = this.jobs.iterator();
            while (sJobs.hasNext()) {
                job2 = ((SortedJobId)sJobs.next()).getJob();
                buf.append(String.format("%s%10s | %32s\n", indent, job2.getId(), job2.getName()));
            }
        }
        if (this.running.size() > 0 && verbose) {
            buf.append("\n");
            buf.append(indent);
            buf.append("running jobs: ");
            buf.append(this.running.size());
            buf.append("\n");
            buf.append(String.format("%s%10s | %32s | %32s\n", indent, "Job Id", "Job name", "Job Step"));
            buf.append(String.format("%s%10.10s-+-%32.32s-+-%32.32s\n", indent, "----------------", "----------------", "----------------"));
            for (IJob job2 : this.running) {
                buf.append(String.format("%s%10s | %32s | %32s\n", indent, job2.getId(), job2.getName(), job2.getCurrentStepName()));
            }
        }
        return buf.toString();
    }
}

