/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.queue.IWait;
import de.axway.aim.controller.master.queue.JobQueue;
import de.axway.aim.controller.master.queue.WaitQueue;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SleepQueue
extends WaitQueue
implements JobQueue {
    private Log log = LogFactory.getLog((String)"master.queue.Sleep");
    private JobQueue queue;
    private CtrlDispAppl dispatcher;
    private Map<IJob, WorkerThread> execThreads = new Hashtable<IJob, WorkerThread>();

    public SleepQueue(JobQueue queue, CtrlDispAppl dispatcher) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().debug((Object)("created, JobQueue: " + queue));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"created");
        }
        try {
            this.setName("SleepQueue");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.queue = queue;
        this.dispatcher = dispatcher;
        this.start();
    }

    @Override
    public void runJob(IExecutable job) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("start job:" + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start: job name/ID: " + job.getName() + "/" + job.getId()));
        }
        long delay = job.getNextExecTime() - System.currentTimeMillis();
        if (delay <= 0L) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)"not sleeping, runqueue");
            }
            this.queue.runJob(job);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)"end");
            }
            if (job instanceof IJob) {
                this.setDelayed((IJob)job, false);
            }
            return;
        }
        if (job instanceof IJob) {
            this.setDelayed((IJob)job, true);
        }
        this.newWaitJob(new SleepJob(job));
        if (job instanceof IJob && delay / 1000L > (long)this.dispatcher.getEdiboss().getTimeHoldJobRam()) {
            ((IJob)job).shrink();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDelayed(IJob job, boolean delayed) {
        boolean isDelayed;
        IJobStep js = (IJobStep)job.getCurrentStep();
        boolean bl = isDelayed = (js.getStatus() & 0x40) == 64;
        if (isDelayed != delayed) {
            Connection con = null;
            try {
                con = this.dispatcher.getConnection();
                ((CtrlJobStep)js).setDelayed(con, delayed);
                con.commit();
            }
            catch (SQLException e) {
                this.getLog().warn((Object)"can not update jobstep status", (Throwable)e);
                js.setDelayed(delayed);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            this.dispatcher.sendUpdateJob(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IJob job, boolean kill) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("start job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start job name/ID: " + job.getName() + "/" + job.getId()));
        }
        if (this.remove(job.getId()) != null) {
            this.getLog().debug((Object)("job " + job.getId() + " removed"));
        }
        WorkerThread thread = null;
        boolean wait = false;
        Map<IJob, WorkerThread> map = this.execThreads;
        synchronized (map) {
            thread = this.execThreads.get(job);
            if (thread != null) {
                this.getLog().info((Object)("job " + job.getId() + " has thread"));
                BlockingQueue<Runnable> queue = this.dispatcher.getThreadPool().getQueue();
                if (!queue.remove(thread)) {
                    wait = true;
                }
            }
        }
        if (wait) {
            while (!thread.isReady()) {
                try {
                    this.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (thread != null) {
            thread.run();
        } else if (!kill) {
            this.setDelayed(job, false);
            map = this.execThreads;
            synchronized (map) {
                this.execThreads.remove(job);
            }
        } else {
            map = this.execThreads;
            synchronized (map) {
                this.execThreads.remove(job);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(IWait job) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("start job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start job ID: " + job.getId()));
        }
        if (((SleepJob)job).getJob() instanceof IJob) {
            IJob ijob = (IJob)((SleepJob)job).getJob();
            SleepThread thread = new SleepThread(ijob);
            Map<IJob, WorkerThread> map = this.execThreads;
            synchronized (map) {
                if (this.contains(job.getId())) {
                    this.execThreads.put(ijob, thread);
                    this.dispatcher.getThreadPool().execute(thread);
                } else {
                    this.getLog().warn((Object)("exec thread for job " + job.getId() + " was removed"));
                    thread.kill();
                }
            }
        } else {
            this.queue.runJob((IExecutable)job.getJob());
        }
        return true;
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    private class SleepThread
    extends WorkerThread {
        private IJob ijob;

        public SleepThread(IJob ijob) {
            super(2);
            this.ijob = ijob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            try {
                SleepQueue.this.setDelayed(this.ijob, false);
                SleepQueue.this.queue.runJob(this.ijob);
            }
            finally {
                Map map = SleepQueue.this.execThreads;
                synchronized (map) {
                    if (SleepQueue.this.execThreads.remove(this.ijob) == null) {
                        log.warn((Object)("can not remove exec thread for job " + this.ijob.getId()));
                    }
                }
            }
        }
    }

    private class SleepJob
    extends IWait {
        public SleepJob(IExecutable job) {
            super(job);
        }

        @Override
        public long getWaitDate() {
            return ((IExecutable)this.getJob()).getNextExecTime();
        }
    }
}

