/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.queue;

import de.axway.aim.controller.master.queue.DumpableQueue;
import de.axway.aim.controller.master.queue.IWait;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;

public abstract class WaitQueue
extends ManagedRunnableImpl
implements DumpableQueue {
    private Map<Long, IWait> jobHash = new Hashtable<Long, IWait>();
    private SortedSet<IWait> jobs = Collections.synchronizedSortedSet(new TreeSet());
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss");
    private boolean shutdown = false;
    private boolean down = true;
    private Object downSync = new Object();
    private Object newJobSync = new Object();
    private boolean newJobWait = false;
    private long waitTime = 0L;

    protected abstract boolean exec(IWait var1) throws Exception;

    protected abstract Log getLog();

    public void start() {
        super.start();
        try {
            while (this.down) {
                this.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String getStatus() {
        return this.getStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus(boolean verbose) {
        StringBuffer buf = null;
        Iterator it = null;
        IWait job2 = null;
        if (this.down) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)"status: down");
            }
            return "down";
        }
        if (this.shutdown) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)"status: shutting down");
            }
            return "shutting down";
        }
        Map<Long, IWait> map = this.jobHash;
        synchronized (map) {
            block22: {
                try {
                    job2 = this.jobs.first();
                }
                catch (NoSuchElementException e) {
                    if (!this.getLog().isTraceEnabled()) break block22;
                    this.getLog().trace((Object)"jobs queue is empty");
                }
            }
            buf = new StringBuffer();
            buf.append(this.jobs.size());
            buf.append(", next run: ");
            if (job2 != null) {
                buf.append(DATE_FORMAT.format(new Date(job2.getFirstWaitDate())));
            } else {
                buf.append("-");
            }
            buf.append(", sleeping: ");
            if (job2 != null) {
                buf.append(this.waitTime / 1000L);
                buf.append(" sec.");
            } else {
                buf.append("-");
            }
            if (verbose && job2 != null) {
                if (job2.hasNameAndStep()) {
                    buf.append("\n  Content:\n");
                    buf.append(String.format("    %10s | %33s | %19s\n", "Job ID", "Job/Step", "Wakup at"));
                    buf.append(String.format("    %10.10s-+-%33.33s-+-%19.19s\n", "---------------------------", "------------------------------------------------------------", "---------------------------"));
                    Map<Long, IWait> map2 = this.jobHash;
                    synchronized (map2) {
                        for (IWait job2 : this.jobs) {
                            buf.append(String.format("    %10s | %33s | %3$tF %3$tT\n", job2.getId(), job2.getJobAndStep(), new Date(job2.getFirstWaitDate())));
                        }
                    }
                } else {
                    buf.append("\n  Content:\n");
                    buf.append(String.format("    %10s | %19s\n", "Job ID", "Wakup at"));
                    buf.append(String.format("    %10.10s-+-%19.19s\n", "---------------------------", "---------------------------"));
                    for (IWait job2 : this.jobs) {
                        buf.append(String.format("    %10s | %2$tF %2$tT\n", job2.getId(), new Date(job2.getFirstWaitDate())));
                    }
                }
            }
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("status: '" + buf + "'"));
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"start:");
        }
        this.shutdown = true;
        if (!this.down) {
            this.interrupt();
        }
        Map<Long, IWait> map = this.newJobSync;
        synchronized (map) {
            if (this.newJobWait) {
                this.newJobSync.notify();
            }
        }
        map = this.downSync;
        synchronized (map) {
            while (!this.down) {
                try {
                    this.downSync.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        map = this.jobHash;
        synchronized (map) {
            this.jobs.clear();
            this.jobHash.clear();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newWaitJob(IWait job) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("start job: " + job));
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start id: " + job.getId()));
        }
        if (this.shutdown) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)"return because of shutdown.");
            }
            return;
        }
        Object object = this.jobHash;
        synchronized (object) {
            this.jobHash.put(job.getId(), job);
            this.jobs.add(job);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)("add job: " + job));
            } else if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("add job ID: " + job.getId() + ", " + new Date(job.getFirstWaitDate())));
            }
        }
        object = this.newJobSync;
        synchronized (object) {
            if (this.newJobWait) {
                this.newJobSync.notify();
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end:");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWait remove(long id) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("start job ID: " + id));
        }
        Map<Long, IWait> map = this.jobHash;
        synchronized (map) {
            IWait job = this.jobHash.remove(id);
            if (job != null) {
                if (!this.jobs.remove(job)) {
                    this.getLog().error((Object)("Cannot remove job " + id + " from jobs"));
                } else if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("job " + id + " removed"));
                }
                return job;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long id) {
        Map<Long, IWait> map = this.jobHash;
        synchronized (map) {
            return this.jobHash.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        Object object;
        this.down = false;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"start: ");
        }
        while (!this.shutdown) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)"doRun loop enter: ");
            }
            do {
                IWait rj = null;
                try {
                    Map<Long, IWait> map = this.jobHash;
                    synchronized (map) {
                        rj = this.jobs.first();
                        if (!this.contains(rj.getId())) {
                            this.getLog().warn((Object)("job " + rj.getId() + " not found in jobHash, ignored"));
                            if (!this.jobs.remove(rj)) {
                                this.getLog().error((Object)("can not remove job " + rj.getId() + " from treeset"));
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            rj = null;
                        } else if (rj.getWaitDate() - System.currentTimeMillis() > 0L && rj.getFirstWaitDate() != rj.getWaitDate()) {
                            this.getLog().warn((Object)("wait date of job " + rj.getId() + " changed: " + rj.getFirstWaitDate() + " -> " + rj.getWaitDate()));
                            this.jobs.remove(rj);
                            rj.reset();
                            this.jobs.add(rj);
                            rj = null;
                        } else {
                            this.waitTime = rj.getWaitDate() - System.currentTimeMillis();
                            if (this.waitTime > 0L) {
                                rj = null;
                            }
                        }
                    }
                }
                catch (NoSuchElementException e) {
                    this.waitTime = Integer.MAX_VALUE;
                }
                if (rj == null) continue;
                try {
                    this.exec(rj);
                    this.remove(rj.getId());
                }
                catch (Exception e) {
                    this.getLog().info((Object)"exec", (Throwable)e);
                    this.waitTime = 1000L;
                }
            } while (this.waitTime <= 0L && !this.shutdown);
            object = this.newJobSync;
            synchronized (object) {
                if (this.waitTime > 10000L && this.jobs.size() > 0) {
                    this.waitTime -= this.waitTime / 10L;
                }
                try {
                    if (!(this.shutdown || this.jobs.size() != 0 && this.waitTime <= 0L)) {
                        this.newJobWait = true;
                        this.newJobSync.wait(this.waitTime);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.newJobWait = false;
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"doRun loop end: ");
        }
        this.down = true;
        object = this.downSync;
        synchronized (object) {
            this.downSync.notifyAll();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"end: ");
        }
    }
}

