/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.tcontrol.IPeriode;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class FixPeriode
implements IPeriode {
    private final int aPeriode;
    private final Date aBasePeriodeDate;

    public FixPeriode(Date basePeriodeDate, int periode) throws Exception {
        if (periode <= 0) {
            throw new CfgException("Out of Range: " + periode);
        }
        if (basePeriodeDate == null) {
            throw new CfgException("Could not calculate nearest time window");
        }
        this.aBasePeriodeDate = (Date)basePeriodeDate.clone();
        this.aPeriode = periode;
    }

    public int getPeriode() {
        return this.aPeriode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date calcNearestPeriode(Date requestDate) {
        Date nearestPeriode;
        Calendar calendar = GregorianCalendar.getInstance();
        long firstValidSeconds = this.aBasePeriodeDate.getTime() / 1000L;
        long requestDateSeconds = requestDate.getTime() / 1000L;
        long diffSeconds = requestDateSeconds - firstValidSeconds;
        long diffNearestSeconds = (diffSeconds + (long)this.aPeriode - 1L) / (long)this.aPeriode * (long)this.aPeriode;
        long d2 = diffNearestSeconds - diffSeconds;
        long nextValidPeriodMillis = (requestDateSeconds + d2) * 1000L;
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTimeInMillis(requestDate.getTime());
            int dst = calendar.get(16);
            calendar.set(14, 0);
            calendar.set(16, dst);
            Date cleanRequestDate = calendar.getTime();
            calendar.setTime(this.aBasePeriodeDate);
            int dst2 = calendar.get(16);
            calendar.set(14, 0);
            calendar.set(16, dst2);
            int baseDstOffset = calendar.get(16);
            calendar.setTimeInMillis(nextValidPeriodMillis);
            int nextDstOffset = calendar.get(16);
            int diffDstOffset = baseDstOffset - nextDstOffset;
            calendar.add(14, diffDstOffset);
            nearestPeriode = calendar.getTime();
            if (nearestPeriode.before(cleanRequestDate)) {
                long reqdiff = (cleanRequestDate.getTime() - nearestPeriode.getTime()) / 1000L;
                int diffDstFix = ((int)(reqdiff - 1L) / this.aPeriode + 1) * this.aPeriode;
                calendar.add(13, diffDstFix);
                nearestPeriode = calendar.getTime();
            }
        }
        return nearestPeriode;
    }
}

