/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.cfg.CfgTimeDate;
import de.axway.aim.controller.master.cfg.CfgTimeOneDate;
import de.axway.aim.controller.master.cfg.CfgTimeTime;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.tcontrol.DateRangeNode;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import de.axway.aim.controller.master.tcontrol.RangeState;
import de.axway.aim.controller.master.tcontrol.TimeRangeNode;
import de.axway.aim.controller.master.tcontrol.WeekdayRangeNode;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public final class NormTimeWindow {
    private NormTimeWindow() {
    }

    public static Map<String, NormalizedTimewindow> normalize(CfgTimeWindow cfgTimeWindow) {
        Hashtable<String, NormalizedTimewindow> noramlizedTimewindowHash = new Hashtable<String, NormalizedTimewindow>();
        Enumeration<String> timewindowKeys = cfgTimeWindow.keys();
        while (timewindowKeys.hasMoreElements()) {
            String timewindowKey = timewindowKeys.nextElement();
            CfgTimeWindowEntry cfgTimeWindowEntry = cfgTimeWindow.get(timewindowKey);
            NormalizedTimewindow normalizedTimewindow = NormTimeWindow.normalizeTimewindowEntry(cfgTimeWindowEntry);
            noramlizedTimewindowHash.put(timewindowKey, normalizedTimewindow);
        }
        return noramlizedTimewindowHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NormalizedTimewindow normalizeTimewindowEntry(CfgTimeWindowEntry cfgTimeWindowEntry) {
        Calendar calendar = GregorianCalendar.getInstance();
        String name = cfgTimeWindowEntry.getName();
        NormalizedTimewindow normalizedTimewindow = new NormalizedTimewindow(name);
        List<CfgTimeDate> cfgTimeDateList = cfgTimeWindowEntry.getDate();
        for (CfgTimeDate cfgTimeDate : cfgTimeDateList) {
            CfgTimeOneDate date = cfgTimeDate.getDate();
            Date from = date.getFrom();
            Date to = date.getTo();
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.setTime(to);
                calendar.add(5, 1);
                to = calendar.getTime();
            }
            RangeState state = date.isAllowed() ? RangeState.ENABLED : RangeState.DISABLED;
            Date weekdayFrom = null;
            Date weekdayTo = null;
            DateRangeNode dateRangeNode = new DateRangeNode(from, to, state);
            if (date.isAllowed()) {
                boolean[] days = cfgTimeDate.getWeekday().getDays();
                for (int dayIndex = 0; dayIndex < 7; ++dayIndex) {
                    Calendar calendar3;
                    int dayIndex2 = (dayIndex + 1) % 7;
                    if (days[dayIndex2]) {
                        if (weekdayFrom != null) continue;
                        calendar3 = calendar;
                        synchronized (calendar3) {
                            calendar.clear();
                            calendar.set(7, 2);
                            calendar.add(7, dayIndex);
                            weekdayFrom = calendar.getTime();
                            continue;
                        }
                    }
                    if (weekdayFrom == null) continue;
                    calendar3 = calendar;
                    synchronized (calendar3) {
                        calendar.clear();
                        calendar.set(7, 2);
                        calendar.add(7, dayIndex);
                        weekdayTo = calendar.getTime();
                    }
                    WeekdayRangeNode weekdayRangeNode = new WeekdayRangeNode(weekdayFrom, weekdayTo, RangeState.ENABLED);
                    dateRangeNode.merge(weekdayRangeNode);
                    weekdayFrom = null;
                    weekdayTo = null;
                }
                if (weekdayFrom != null) {
                    Calendar dayIndex = calendar;
                    synchronized (dayIndex) {
                        calendar.clear();
                        calendar.set(7, 2);
                        calendar.add(7, 7);
                        weekdayTo = calendar.getTime();
                    }
                    WeekdayRangeNode weekdayRangeNode = new WeekdayRangeNode(weekdayFrom, weekdayTo, RangeState.ENABLED);
                    dateRangeNode.merge(weekdayRangeNode);
                    weekdayFrom = null;
                    weekdayTo = null;
                }
                List<CfgTimeTime> cfgTimeTimeList = cfgTimeDate.getTime();
                for (CfgTimeTime cfgTimeTime : cfgTimeTimeList) {
                    Date timeFrom = cfgTimeTime.getFrom();
                    Date timeTo = cfgTimeTime.getTo();
                    Calendar calendar4 = calendar;
                    synchronized (calendar4) {
                        calendar.setTime(timeTo);
                        calendar.add(13, 1);
                        timeTo = calendar.getTime();
                    }
                    RangeState timeState = cfgTimeTime.isAllowed() ? RangeState.ENABLED : RangeState.DISABLED;
                    TimeRangeNode timeRangeNode = new TimeRangeNode(timeFrom, timeTo, timeState);
                    for (WeekdayRangeNode weekdayRangeNode : dateRangeNode.getTreeData()) {
                        weekdayRangeNode.merge(timeRangeNode);
                    }
                }
            }
            normalizedTimewindow.merge(dateRangeNode);
        }
        return normalizedTimewindow;
    }
}

