/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.ITimeable;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Scheduler<Data>
implements ITimeable<Data> {
    private static final Log LOG = LogFactory.getLog((String)"de.axway.aim.controller.master.tcontrol.Timer");
    protected final TreeSet<ITimeable<Data>> treeSet = new TreeSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec(Date now) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scheduler.exec: " + now + " start event creation."));
        }
        while (this.treeSet.size() > 0) {
            ITimeable<Data> data;
            TreeSet<ITimeable<Data>> treeSet = this.treeSet;
            synchronized (treeSet) {
                data = this.treeSet.first();
                long l = now.getTime() - data.getEarliest().getTime();
                if (data.getEarliest() == null) {
                    break;
                }
                if (data.getEarliest().after(now)) {
                    break;
                }
                if (l > 1000L && LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Scheduler.exec is late: " + l + " ms, Event: " + data));
                }
                this.treeSet.remove(data);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Scheduler.exec removed: " + this.treeSet.size() + "\n   " + data));
                }
            }
            data.exec(now);
            Date dataEarliest = data.getEarliest();
            if (dataEarliest == null) continue;
            this.treeSet.add(data);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Scheduler.exec re-added:  " + this.treeSet.size() + "\n   " + data));
        }
        LOG.debug((Object)"Scheduler.exec: end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ITimeable<Data> timeable) {
        TreeSet<ITimeable<Data>> treeSet = this.treeSet;
        synchronized (treeSet) {
            this.treeSet.add(timeable);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scheduler.add added number " + this.treeSet.size() + ": " + timeable));
            }
        }
    }

    @Override
    public int compareTo(Data o) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getNext(Date now) {
        Date earliest = this.getEarliest();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scheduler.getNext earliest : " + earliest));
        }
        Date baseNext = now == null ? earliest : (now.before(earliest) ? earliest : now);
        Date next = null;
        TreeSet<ITimeable<Data>> treeSet = this.treeSet;
        synchronized (treeSet) {
            ITimeable<Data> data;
            Date dataEarliest;
            Iterator<ITimeable<Data>> dataIterator = this.treeSet.iterator();
            while (dataIterator.hasNext() && (dataEarliest = (data = dataIterator.next()).getEarliest()) != null) {
                if (dataEarliest.after(baseNext)) {
                    if (next != null) break;
                    next = dataEarliest;
                    break;
                }
                Date nextRunDate = data.getNext(baseNext);
                if (next != null && !nextRunDate.before(next)) continue;
                next = nextRunDate;
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getEarliest() {
        TreeSet<ITimeable<Data>> treeSet = this.treeSet;
        synchronized (treeSet) {
            if (this.treeSet.size() == 0) {
                return null;
            }
            return this.treeSet.first().getEarliest();
        }
    }
}

