/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.Clock;
import de.axway.aim.controller.master.tcontrol.IClock;
import de.axway.aim.controller.master.tcontrol.ITimeable;
import de.axway.aim.controller.master.tcontrol.TControlError;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Timer<Data>
extends ManagedRunnableImpl {
    private static final Log LOG = LogFactory.getLog((String)"master.tcontrol.Timer");
    private EState state;
    private Object runSync = new Object();
    private final ITimeable<Data> aTimeable;
    private IClock aClock = new Clock();
    private static int id = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer(ITimeable<Data> timeable) {
        this.state = EState.CREATED;
        this.aTimeable = timeable;
        Timer timer = this;
        synchronized (timer) {
            this.setName("tcontrol.Timer_" + id++);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Timer(" + this.getName() + ") - created"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doRun() {
        Object object = this.runSync;
        synchronized (object) {
            if (!EState.CREATED.equals((Object)this.state)) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Timer(" + this.getName() + ") - do not start again - use new instance instead."));
                }
                return;
            }
            this.state = EState.RUNNING;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Timer(" + this.getName() + ") - started"));
        }
        try {
            while (EState.RUNNING.equals((Object)this.state)) {
                this.activeRun();
            }
        }
        catch (Throwable e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Timer(" + this.getName() + ") - break down"), e);
            }
            throw new TControlError(e);
        }
        finally {
            object = this.runSync;
            synchronized (object) {
                this.state = EState.TERMINATED;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Timer(" + this.getName() + ") - stopped"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activeRun() {
        block9: {
            Date now = this.aClock.getNow();
            Date nextRun = this.aTimeable.getEarliest();
            try {
                if (nextRun == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Timer(" + this.getName() + ") - no time event found - wait for stopping"));
                    }
                    this.aClock.timerWait(0L);
                } else {
                    this.waitUntil(nextRun);
                    now = this.aClock.getNow();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Timer(" + this.getName() + ") - execute timeable at " + nextRun));
                    }
                    this.aTimeable.exec(now);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)("Timer(" + this.getName() + ") - wait interrupted"), (Throwable)e);
            }
        }
        Timer timer = this;
        synchronized (timer) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public final void waitUntil(Date nextRun) throws InterruptedException {
        Date nextRun2 = (Date)nextRun.clone();
        Date now = (Date)this.aClock.getNow().clone();
        long diff = nextRun2.getTime() - now.getTime();
        if (diff > 0L) {
            if (LOG.isDebugEnabled()) {
                String message = "Timer(" + this.getName() + ")\n";
                message = message + "    nextRun: " + nextRun2 + " (" + nextRun2.getTime() + " ms)";
                message = message + "    now    : " + now + " (" + now.getTime() + " ms)";
                message = message + "    diff: " + diff + " ms";
                LOG.debug((Object)message);
            }
            this.aClock.timerWait(diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.runSync;
        synchronized (object) {
            if (!EState.RUNNING.equals((Object)this.state)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Timer(" + this.getName() + ") - timer was not started"));
                }
                this.state = EState.TERMINATED;
                return;
            }
            this.state = EState.STOPPING;
            this.aClock.interrupt();
        }
        while (!EState.TERMINATED.equals((Object)this.state)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Timer(" + this.getName() + ") - wait for termination"));
            }
            this.aClock.interrupt();
            object = this;
            synchronized (object) {
                try {
                    ((Object)((Object)this)).wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public final void setClock(IClock clock) {
        this.aClock = clock;
    }

    private static enum EState {
        CREATED,
        RUNNING,
        STOPPING,
        TERMINATED;

    }
}

