/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.tcontrol;

import de.axway.aim.controller.master.tcontrol.AbstractRangeTree;
import de.axway.aim.controller.master.tcontrol.FixPeriode;
import de.axway.aim.controller.master.tcontrol.IPeriode;
import de.axway.aim.controller.master.tcontrol.RangeState;
import de.axway.aim.controller.master.tcontrol.TControlError;
import de.axway.aim.controller.master.tcontrol.TimeRangeNode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeekdayRangeNode
extends AbstractRangeTree<Date, WeekdayRangeNode, TimeRangeNode> {
    private static Log log = LogFactory.getLog((String)"de.axway.aim.controller.master.tcontrol.CfgJSelectScheduler");
    private static final int RANGE_DAY = 86400;
    private static final int RANGE_WEEK = 604800;
    private static final DateFormat WEEKDAY_FORMAT = new SimpleDateFormat("EEE", Locale.ENGLISH);
    private int aFromIndex = 0;
    private int aToIndex = 7;

    public WeekdayRangeNode(Date from, Date to, RangeState state) {
        this.setFrom(from);
        this.setTo(to);
        this.setState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFrom(Date from) {
        Date time;
        Calendar calendar;
        Calendar calendar2 = calendar = GregorianCalendar.getInstance();
        synchronized (calendar2) {
            calendar.setTime(from);
            int dayOfWeek = calendar.get(7);
            this.aFromIndex = (dayOfWeek + 5) % 7;
            if (this.aFromIndex >= this.aToIndex) {
                throw new TControlError("internal error");
            }
            calendar.clear();
            calendar.set(7, 2);
            calendar.add(7, this.aFromIndex);
            time = calendar.getTime();
        }
        super.setFrom(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setTo(Date to) {
        Date time;
        Calendar calendar;
        Calendar calendar2 = calendar = GregorianCalendar.getInstance();
        synchronized (calendar2) {
            calendar.setTime(to);
            int dayOfWeek = calendar.get(7);
            this.aToIndex = (dayOfWeek + 5) % 7;
            if (this.aToIndex == 0) {
                this.aToIndex += 7;
            }
            if (this.aFromIndex >= this.aToIndex) {
                throw new TControlError("internal error");
            }
            calendar.clear();
            calendar.set(7, 2);
            calendar.add(7, this.aToIndex);
            time = calendar.getTime();
        }
        super.setTo(time);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getState().equals((Object)RangeState.ENABLED)) {
            sb.append("+");
        } else if (this.getState().equals((Object)RangeState.DISABLED)) {
            sb.append("-");
        } else {
            sb.append("?");
        }
        sb.append("[" + WEEKDAY_FORMAT.format((Date)this.getFrom()) + ", " + WEEKDAY_FORMAT.format((Date)this.getTo()) + "), \n");
        for (TimeRangeNode timeData : this.getTreeData()) {
            sb.append("    " + timeData.toString() + "\n");
        }
        return sb.toString();
    }

    @Override
    public void merge(TimeRangeNode rangeNode) {
        if (this.getTreeData().size() == 0) {
            super.merge(new TimeRangeNode(this));
        }
        super.merge(rangeNode);
    }

    @Override
    public void mergeContent(WeekdayRangeNode rangeNode) {
        if (this.getState().equals((Object)RangeState.DISABLED)) {
            return;
        }
        if (this.getState().equals((Object)RangeState.ENABLED) && rangeNode.getTreeData().size() > 0) {
            this.setState(RangeState.NEUTRAL);
        }
        for (TimeRangeNode timeRangeNode : rangeNode.getTreeData()) {
            this.merge(timeRangeNode.cloneNode());
        }
    }

    @Override
    public WeekdayRangeNode cloneNode() {
        WeekdayRangeNode rangeNode = new WeekdayRangeNode((Date)this.getFrom(), (Date)this.getTo(), this.getState());
        rangeNode.mergeContent(this);
        return rangeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date nearestValid(IPeriode periode, Date requestDate, Date maxDate) {
        Date verifyDate;
        Calendar calendar = GregorianCalendar.getInstance();
        if (this.getState().equals((Object)RangeState.DISABLED)) {
            return null;
        }
        Date nearestValid = null;
        if (periode != null && periode instanceof FixPeriode) {
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.setTime(requestDate);
                int reqMilli = calendar.get(14);
                FixPeriode fixPeriode = (FixPeriode)periode;
                verifyDate = fixPeriode.calcNearestPeriode(requestDate);
                calendar.setTime(verifyDate);
                calendar.set(14, reqMilli);
                verifyDate = calendar.getTime();
            }
        } else {
            verifyDate = requestDate;
        }
        int modValue = 0;
        nearestValid = this.nearestValidLocal(periode, verifyDate, maxDate);
        if (nearestValid != null) {
            return nearestValid;
        }
        TreeSet<Integer> modValueTreeSet = new TreeSet<Integer>();
        while (verifyDate == null || verifyDate.compareTo(maxDate) == -1) {
            for (TimeRangeNode dateData : this.getTreeData()) {
                Date subNearestValid = dateData.nearestValid(periode, verifyDate, maxDate);
                if (nearestValid != null && (subNearestValid == null || nearestValid.compareTo(subNearestValid) != 1)) continue;
                nearestValid = subNearestValid;
            }
            if (nearestValid == null) {
                return null;
            }
            verifyDate = nearestValid;
            Date verifyFromTime = this.getFrom(verifyDate);
            Date verifyToTime = this.getTo(verifyDate);
            int requestDateCompareToFromDate = nearestValid.compareTo(verifyFromTime);
            int requestDateCompareToToDate = nearestValid.compareTo(verifyToTime);
            if (requestDateCompareToFromDate > -1 && requestDateCompareToToDate < 0) {
                return nearestValid;
            }
            nearestValid = null;
            long lastTime = verifyDate.getTime();
            Calendar calendar3 = calendar;
            synchronized (calendar3) {
                calendar.setTime(verifyDate);
                calendar.add(5, 1);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                verifyDate = calendar.getTime();
            }
            long newTime = verifyDate.getTime();
            if (periode != null && periode instanceof FixPeriode) {
                FixPeriode fixPeriode = (FixPeriode)periode;
                int periodeOffset = (int)((long)fixPeriode.getPeriode() - (newTime - lastTime) / 1000L % (long)fixPeriode.getPeriode());
                Calendar calendar4 = calendar;
                synchronized (calendar4) {
                    calendar.setTime(verifyDate);
                    calendar.add(13, periodeOffset);
                    verifyDate = calendar.getTime();
                }
                modValue = (modValue + fixPeriode.getPeriode()) % 604800;
                if (modValueTreeSet.contains(modValue)) {
                    return null;
                }
                modValueTreeSet.add(modValue);
                continue;
            }
            verifyDate = this.getFrom(verifyDate);
        }
        return nearestValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date nearestValidLocal(IPeriode periodex, Date requestDate, Date maxDate) {
        IPeriode periode;
        Calendar calendar;
        block15: {
            calendar = GregorianCalendar.getInstance();
            if (periodex == null) {
                Date time;
                Calendar calendar2 = calendar;
                synchronized (calendar2) {
                    calendar.clear();
                    time = calendar.getTime();
                }
                try {
                    periode = new FixPeriode(time, 86400);
                }
                catch (Exception e) {
                    periode = null;
                    if (log.isErrorEnabled()) {
                        log.error((Object)"error", (Throwable)e);
                    }
                    break block15;
                }
            }
            periode = periodex;
        }
        if (!this.getState().equals((Object)RangeState.ENABLED)) {
            return null;
        }
        Date verifyDate = requestDate;
        int modValue = 0;
        TreeSet<Integer> modValueTreeSet = new TreeSet<Integer>();
        while (verifyDate.compareTo(maxDate) == -1) {
            Date verifyFromTime = this.getFrom(verifyDate);
            Date verifyToTime = this.getTo(verifyDate);
            int requestDateCompareToFromDate = verifyDate.compareTo(verifyFromTime);
            int requestDateCompareToToDate = verifyDate.compareTo(verifyToTime);
            if (requestDateCompareToFromDate > -1 && requestDateCompareToToDate < 0) {
                return verifyDate;
            }
            if (periode != null && periode instanceof FixPeriode) {
                FixPeriode fixPeriode = (FixPeriode)periode;
                Calendar calendar3 = calendar;
                synchronized (calendar3) {
                    calendar.setTime(verifyDate);
                    calendar.add(13, fixPeriode.getPeriode());
                    calendar.set(14, 0);
                    verifyDate = calendar.getTime();
                }
                modValue = (modValue + fixPeriode.getPeriode()) % 604800;
                if (modValueTreeSet.contains(modValue)) {
                    return null;
                }
                modValueTreeSet.add(modValue);
                continue;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFrom(Date requestDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        Date from = (Date)super.getFrom();
        if (requestDate == null) {
            return from;
        }
        Date to = (Date)super.getTo();
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            int requestIndex;
            calendar.setTime(from);
            int dayOfWeekFrom = calendar.get(7);
            calendar.setTime(to);
            int dayOfWeekTo = calendar.get(7);
            calendar.setTime(requestDate);
            int dayOfWeekRequest = calendar.get(7);
            int fromIndex = (dayOfWeekFrom + 5) % 7;
            int toIndex = (dayOfWeekTo + 5) % 7;
            if (toIndex == 0) {
                toIndex += 7;
            }
            int diff = (requestIndex = (dayOfWeekRequest + 5) % 7) < toIndex ? fromIndex - requestIndex : (7 + fromIndex - requestIndex) % 7;
            calendar.add(7, diff);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getTo(Date requestDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        Date to = (Date)super.getTo();
        if (requestDate == null) {
            return to;
        }
        Date from = (Date)super.getFrom();
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.setTime(from);
            calendar.setTime(to);
            int dayOfWeekTo = calendar.get(7);
            calendar.setTime(requestDate);
            int dayOfWeekRequest = calendar.get(7);
            int toIndex = (dayOfWeekTo + 5) % 7;
            int requestIndex = (dayOfWeekRequest + 5) % 7;
            int diff = requestIndex < toIndex ? toIndex - requestIndex : 7 + toIndex - requestIndex;
            calendar.add(7, diff);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
    }

    @Override
    public final void setState(RangeState state) {
        super.setState(state);
    }
}

